/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.collect;

import buildcraft.lib.misc.collect.TypedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class TypedMapHierarchy<V>
implements TypedMap<V> {
    private final Map<Class<?>, Node<?>> nodes = new HashMap();

    @Override
    public <T extends V> T get(Class<T> clazz) {
        Node<?> node = this.nodes.get(clazz);
        if (node == null) {
            return null;
        }
        return clazz.cast(node.getFirstValue());
    }

    @Override
    public void put(V value) {
        Class<?> clazz = value.getClass();
        Node<?> node = this.nodes.get(clazz);
        if (node == null) {
            node = this.putNode(clazz);
        }
        node.setValue(value);
    }

    @Nullable
    private Node<?> getNode(Class<?> clazz) {
        return this.nodes.get(clazz);
    }

    private <T> Node<T> putNode(Class<T> clazz) {
        Node<T> node = new Node<T>(clazz);
        this.nodes.put(clazz, node);
        for (Class<?> cls : TypedMapHierarchy.getAllDirectParents(clazz)) {
            Node<?> oNode = this.nodes.get(cls);
            if (oNode == null) {
                oNode = this.putNode(cls);
            }
            oNode.children.add(node);
            node.parents.add(oNode);
        }
        return node;
    }

    private static <T> List<Class<?>> getAllDirectParents(Class<T> clazz) {
        ArrayList list = new ArrayList();
        Class<T> s = clazz.getSuperclass();
        if (s != null) {
            list.add(s);
        }
        Collections.addAll(list, clazz.getInterfaces());
        return list;
    }

    @Override
    public void clear() {
        this.nodes.clear();
    }

    @Override
    public void remove(V value) {
        Class<?> clazz = value.getClass();
        Node<?> node = this.getNode(clazz);
        if (node == null || !Objects.equals(value, node.value)) {
            return;
        }
        node.value = null;
        this.removeNode(node);
    }

    private <T> void removeNode(Node<T> node) {
        if (node.children.isEmpty()) {
            this.nodes.remove(node.clazz);
            for (Node<?> p : node.parents) {
                p.children.remove(node);
                this.removeNode(p);
            }
        }
    }

    static class Node<T> {
        final Class<T> clazz;
        final List<Node<?>> parents = new ArrayList();
        final List<Node<?>> children = new ArrayList();
        T value;

        Node(Class<T> clazz) {
            this.clazz = clazz;
        }

        void setValue(Object newValue) {
            this.value = this.clazz.cast(newValue);
        }

        T getFirstValue() {
            if (this.value != null) {
                return this.value;
            }
            for (Node<?> child : this.children) {
                Object val = child.getFirstValue();
                if (val == null) continue;
                return this.clazz.cast(val);
            }
            return null;
        }
    }
}

