/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public class WorkerThreadUtil {
    private static final ExecutorService WORKING_POOL;
    private static final ExecutorService DEPENDANT_WORKING_POOL;
    private static final ExecutorService MONITORING_POOL;
    private static final boolean DEBUG;

    public static void executeWorkTask(Runnable task) {
        WorkerThreadUtil.executeWorkTask(new CallableDelegate(task));
    }

    public static <T> Future<T> executeWorkTask(Callable<T> task) {
        String taskType;
        Task<T> taskMonitor;
        Future<T> future;
        Class<?> taskClass = task.getClass();
        if (task instanceof CallableDelegate) {
            taskClass = ((CallableDelegate)task).getRealClass();
        }
        if (!(future = WORKING_POOL.submit(taskMonitor = new Task<T>(task, taskType = taskClass.getSimpleName()))).isDone()) {
            WorkerThreadUtil.executeMonitoringTask(new MonitorTask(taskMonitor, future));
        }
        return future;
    }

    public static <T> T executeWorkTaskWaiting(Callable<T> task) throws InterruptedException {
        try {
            return WorkerThreadUtil.executeWorkTask(task).get();
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void executeDependantTask(Runnable task) {
        DEPENDANT_WORKING_POOL.execute(task);
    }

    public static <T> Future<T> executeDependantTask(Callable<T> callable) {
        return DEPENDANT_WORKING_POOL.submit(callable);
    }

    public static void executeMonitoringTask(Runnable task) {
        if (DEBUG) {
            MONITORING_POOL.execute(task);
        }
    }

    static {
        DEBUG = BCDebugging.shouldDebugLog("lib.threads");
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int max = Math.max(1, availableProcessors / 3);
        if (DEBUG) {
            BCLog.logger.info("[lib.threads] Creating 2 thread pools with up to " + max + " threads each.");
        }
        BasicThreadFactory factory = new BasicThreadFactory.Builder().daemon(false).namingPattern("BuildCraft Worker Thread %d").uncaughtExceptionHandler((thread, e) -> {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }).build();
        ThreadPoolExecutor.CallerRunsPolicy rejectHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        WORKING_POOL = new ThreadPoolExecutor(0, max, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)factory, rejectHandler);
        factory = new BasicThreadFactory.Builder().daemon(false).namingPattern("BuildCraft Dependant Worker Thread %d").build();
        DEPENDANT_WORKING_POOL = new ThreadPoolExecutor(0, max, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)factory, rejectHandler);
        if (DEBUG) {
            factory = new BasicThreadFactory.Builder().daemon(false).namingPattern("BuildCraft Monitoring Thread %d").build();
            MONITORING_POOL = Executors.newCachedThreadPool((ThreadFactory)factory);
        } else {
            MONITORING_POOL = null;
        }
    }

    private static class MonitorTask
    implements Runnable {
        private final Task<?> task;
        private final Future<?> future;

        public MonitorTask(Task<?> task, Future<?> future) {
            this.task = task;
            this.future = future;
        }

        @Override
        public void run() {
            try {
                this.runThrowable();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private void runThrowable() throws InterruptedException {
            long startMonitor = System.currentTimeMillis();
            this.task.start.await();
            if (System.currentTimeMillis() - startMonitor > 100L) {
                BCLog.logger.warn("[lib.threads] A task took a long time to start! (more than 100 ms) [" + ((Task)this.task).taskType + "]");
            }
            try {
                this.future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException e) {
                BCLog.logger.warn("[lib.threads] A task took too long! (more than 100 ms) [" + ((Task)this.task).taskType + "]");
                try {
                    this.future.get(9900L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException e1) {
                    BCLog.logger.warn("[lib.threads] A task took WAAAAY too long! (more than 10 seconds) [" + ((Task)this.task).taskType + "]");
                    this.task.end.await();
                    BCLog.logger.info("[lib.threads] The task FINALLY completed after " + (System.currentTimeMillis() - startMonitor) + "ms");
                }
            }
        }
    }

    private static class Task<T>
    implements Callable<T> {
        final CountDownLatch start = new CountDownLatch(1);
        final CountDownLatch end = new CountDownLatch(1);
        private final Callable<T> delegate;
        private final String taskType;

        public Task(Callable<T> delegate, String taskType) {
            this.delegate = delegate;
            this.taskType = taskType;
        }

        @Override
        public T call() throws Exception {
            if (DEBUG) {
                BCLog.logger.info("[lib.threads] A task has been started [" + this.taskType + "]");
            }
            this.start.countDown();
            try {
                T result = this.delegate.call();
                if (DEBUG) {
                    BCLog.logger.info("[lib.threads] A task has finished successfully [" + this.taskType + "]");
                }
                T t = result;
                return t;
            }
            catch (Throwable t) {
                BCLog.logger.info("[lib.threads] A task failed! [" + this.taskType + "]", t);
                throw Throwables.propagate((Throwable)t);
            }
            finally {
                this.end.countDown();
            }
        }
    }

    private static class CallableDelegate
    implements Callable<Void> {
        private final Runnable runnable;

        public CallableDelegate(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public Void call() throws Exception {
            this.runnable.run();
            return null;
        }

        public Class<?> getRealClass() {
            return this.runnable.getClass();
        }
    }
}

