/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.misc.data.DelayedList;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.PacketBufferBC;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.StringUtil;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageUtil {
    private static final DelayedList<Runnable> DELAYED_SERVER_TASKS = DelayedList.createConcurrent();
    private static final DelayedList<Runnable> DELAYED_CLIENT_TASKS = DelayedList.createConcurrent();

    public static void doDelayedServer(Runnable task) {
        MessageUtil.doDelayedServer(1, task);
    }

    public static void doDelayedServer(int delay, Runnable task) {
        DELAYED_SERVER_TASKS.add(delay, task);
    }

    public static void doDelayedClient(Runnable task) {
        MessageUtil.doDelayedClient(1, task);
    }

    public static void doDelayedClient(int delay, Runnable task) {
        DELAYED_CLIENT_TASKS.add(delay, task);
    }

    public static void postServerTick() {
        for (Runnable runnable : DELAYED_SERVER_TASKS.advance()) {
            runnable.run();
        }
    }

    public static void postClientTick() {
        for (Runnable runnable : DELAYED_CLIENT_TASKS.advance()) {
            runnable.run();
        }
    }

    public static void sendToAllWatching(World worldObj, BlockPos pos, IMessage message) {
        if (worldObj instanceof WorldServer) {
            WorldServer server = (WorldServer)worldObj;
            PlayerChunkMapEntry playerChunkMap = server.func_184164_w().func_187301_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            if (playerChunkMap == null) {
                return;
            }
            playerChunkMap.func_187271_a(0.0, player -> {
                MessageManager.sendTo(message, player);
                return false;
            });
        }
    }

    public static void sendToPlayers(Iterable<EntityPlayer> players, IMessage message) {
        for (EntityPlayer player : players) {
            if (!(player instanceof EntityPlayerMP)) continue;
            MessageManager.sendTo(message, (EntityPlayerMP)player);
        }
    }

    public static void writeBooleanArray(PacketBuffer buf, boolean[] bool) {
        PacketBufferBC bufBc = PacketBufferBC.asPacketBufferBc((ByteBuf)buf);
        for (boolean b : bool) {
            bufBc.writeBoolean(b);
        }
    }

    public static boolean[] readBooleanArray(PacketBuffer buf, int length) {
        boolean[] total = new boolean[length];
        MessageUtil.readBooleanArray(buf, total);
        return total;
    }

    public static void readBooleanArray(PacketBuffer buf, boolean[] into) {
        PacketBufferBC bufBc = PacketBufferBC.asPacketBufferBc((ByteBuf)buf);
        for (int i = 0; i < into.length; ++i) {
            into[i] = bufBc.readBoolean();
        }
    }

    public static void writeBlockPosArray(PacketBuffer buffer, BlockPos[] arr) {
        boolean[] existsArray = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            existsArray[i] = arr[i] != null;
        }
        MessageUtil.writeBooleanArray(buffer, existsArray);
        for (BlockPos pos : arr) {
            if (pos == null) continue;
            MessageUtil.writeBlockPos(buffer, pos);
        }
    }

    public static BlockPos[] readBlockPosArray(PacketBuffer buffer, int length) {
        BlockPos[] arr = new BlockPos[length];
        boolean[] existsArray = MessageUtil.readBooleanArray(buffer, length);
        for (int i = 0; i < length; ++i) {
            if (!existsArray[i]) continue;
            arr[i] = MessageUtil.readBlockPos(buffer);
        }
        return arr;
    }

    public static void writeBlockPos(PacketBuffer buffer, BlockPos pos) {
        buffer.func_150787_b(pos.func_177958_n());
        buffer.func_150787_b(pos.func_177956_o());
        buffer.func_150787_b(pos.func_177952_p());
    }

    public static BlockPos readBlockPos(PacketBuffer buffer) {
        return new BlockPos(buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a());
    }

    public static void writeVec3d(PacketBuffer buffer, Vec3d vec) {
        buffer.writeDouble(vec.field_72450_a);
        buffer.writeDouble(vec.field_72448_b);
        buffer.writeDouble(vec.field_72449_c);
    }

    public static Vec3d readVec3d(PacketBuffer buffer) {
        return new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static void writeGameProfile(PacketBuffer buffer, GameProfile profile) {
        if (profile != null && profile.isComplete()) {
            buffer.writeBoolean(true);
            buffer.func_179252_a(profile.getId());
            buffer.func_180714_a(profile.getName());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static GameProfile readGameProfile(PacketBuffer buffer) {
        String name;
        UUID uuid;
        GameProfile profile;
        if (buffer.readBoolean() && (profile = new GameProfile(uuid = buffer.func_179253_g(), name = buffer.func_150789_c(256))).isComplete()) {
            return profile;
        }
        return null;
    }

    public static void writeBlockState(PacketBuffer buf, IBlockState state) {
        Block block = state.func_177230_c();
        buf.func_150787_b(Block.field_149771_c.func_148757_b((Object)block));
        int meta = block.func_176201_c(state);
        buf.writeByte(meta);
        IBlockState readState = block.func_176203_a(meta);
        if (readState != state) {
            buf.writeBoolean(true);
            HashMap<IProperty, Comparable> differingProperties = new HashMap<IProperty, Comparable>();
            for (IProperty iProperty : state.func_177227_a()) {
                Comparable readValue;
                Comparable inputValue = state.func_177229_b(iProperty);
                if (inputValue.equals(readValue = readState.func_177229_b(iProperty))) continue;
                differingProperties.put(iProperty, inputValue);
            }
            buf.writeByte(differingProperties.size());
            for (Map.Entry entry : differingProperties.entrySet()) {
                buf.func_180714_a(((IProperty)entry.getKey()).func_177701_a());
                buf.func_180714_a(((IProperty)entry.getKey()).func_177702_a((Comparable)entry.getValue()));
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public static IBlockState readBlockState(PacketBuffer buf) {
        int id = buf.func_150792_a();
        Block block = (Block)Block.field_149771_c.func_148754_a(id);
        short meta = buf.readUnsignedByte();
        IBlockState state = block.func_176203_a((int)meta);
        if (buf.readBoolean()) {
            int count = buf.readByte();
            for (int p = 0; p < count; ++p) {
                String name = buf.func_150789_c(256);
                String value = buf.func_150789_c(256);
                IProperty prop = state.func_177230_c().func_176194_O().func_185920_a(name);
                state = MessageUtil.propertyReadHelper(state, value, prop);
            }
        }
        return state;
    }

    private static <T extends Comparable<T>> IBlockState propertyReadHelper(IBlockState state, String value, IProperty<T> prop) {
        return state.func_177226_a(prop, (Comparable)prop.func_185929_b(value).orNull());
    }

    public static void writeEnumOrNull(ByteBuf buffer, Enum<?> value) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        if (value == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeEnumValue(value);
        }
    }

    public static <E extends Enum<E>> E readEnumOrNull(ByteBuf buffer, Class<E> clazz) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        if (buf.readBoolean()) {
            return buf.func_179257_a(clazz);
        }
        return null;
    }

    public static <E extends Enum<E>> void writeEnumSet(ByteBuf buffer, Set<E> set, Class<E> clazz) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        if (constants == null) {
            throw new IllegalArgumentException("Not an enum type " + clazz);
        }
        for (Enum e : constants) {
            buf.writeBoolean(set.contains(e));
        }
    }

    public static <E extends Enum<E>> EnumSet<E> readEnumSet(ByteBuf buffer, Class<E> clazz) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        if (constants == null) {
            throw new IllegalArgumentException("Not an enum type " + clazz);
        }
        EnumSet<Enum> set = EnumSet.noneOf(clazz);
        for (Enum e : constants) {
            if (!buf.readBoolean()) continue;
            set.add(e);
        }
        return set;
    }

    public static void sendReturnMessage(MessageContext context, IMessage reply) {
        EntityPlayer player = BCLibProxy.getProxy().getPlayerForContext(context);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            MessageManager.sendTo(reply, playerMP);
        } else if (player != null) {
            MessageManager.sendToServer(reply);
        }
    }

    public static PacketBuffer asPacketBuffer(ByteBuf buf) {
        if (buf instanceof PacketBuffer) {
            return (PacketBuffer)buf;
        }
        return new PacketBuffer(buf);
    }

    public static void ensureEmpty(ByteBuf buf, boolean throwError, String extra) {
        int readableBytes;
        int rb = readableBytes = buf.readableBytes();
        if (buf instanceof PacketBufferBC) {
            // empty if block
        }
        if (readableBytes > 0) {
            int to;
            int from;
            int ri = buf.readerIndex();
            byte[] selection = new byte[buf.writerIndex()];
            buf.getBytes(0, selection);
            StringBuilder sb = new StringBuilder("\n");
            int i = 0;
            while ((from = i * 20) < (to = Math.min(from + 20, selection.length))) {
                byte[] part = Arrays.copyOfRange(selection, from, to);
                for (int j = 0; j < part.length; ++j) {
                    byte b = part[j];
                    sb.append(StringUtil.byteToHexStringPadded((int)b));
                    if (from + j + 1 == ri) {
                        sb.append('#');
                        continue;
                    }
                    sb.append(' ');
                }
                int leftOver = from - to + 20;
                for (int j = 0; j < leftOver; ++j) {
                    sb.append("   ");
                }
                sb.append("| ");
                for (byte b : part) {
                    char c = (char)b;
                    if (c < ' ' || c > '\u007f') {
                        c = ' ';
                    }
                    sb.append(c);
                }
                sb.append('\n');
                ++i;
            }
            sb.append("-- " + rb);
            IllegalStateException ex = new IllegalStateException("Did not fully read the data! [" + extra + "]" + sb);
            if (throwError) {
                throw ex;
            }
            BCLog.logger.warn((Object)ex);
            buf.clear();
        }
    }
}

