/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import java.util.ArrayDeque;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.vecmath.Point2i;
import net.minecraft.util.math.BlockPos;

public class DrawingUtil {
    public static void drawEllipse(int cx, int cy, int rx, int ry, boolean filled, BiConsumer<Integer, Integer> drawPixel) {
        int i;
        rx = Math.max(1, rx);
        ry = Math.max(1, ry);
        int rx2 = rx * rx;
        int ry2 = ry * ry;
        int x = 0;
        int y = ry;
        int sigma = 2 * ry2 + rx2 * (1 - 2 * ry);
        while (ry2 * x <= rx2 * y) {
            if (filled) {
                for (i = -x; i <= x; ++i) {
                    drawPixel.accept(cx + i, cy + y);
                    drawPixel.accept(cx + i, cy - y);
                }
                for (i = -y; i <= y; ++i) {
                    drawPixel.accept(cx + x, cx + i);
                    drawPixel.accept(cx - x, cx + i);
                }
            } else {
                drawPixel.accept(cx + x, cy + y);
                drawPixel.accept(cx - x, cy + y);
                drawPixel.accept(cx + x, cy - y);
                drawPixel.accept(cx - x, cy - y);
            }
            if (sigma >= 0) {
                sigma += 4 * rx2 * (1 - y);
                --y;
            }
            sigma += ry2 * (4 * x + 6);
            ++x;
        }
        x = rx;
        y = 0;
        sigma = 2 * rx2 + ry2 * (1 - 2 * rx);
        while (rx2 * y <= ry2 * x) {
            if (filled) {
                for (i = -x; i <= x; ++i) {
                    drawPixel.accept(cx + i, cy + y);
                    drawPixel.accept(cx + i, cy - y);
                }
                for (i = -y; i <= y; ++i) {
                    drawPixel.accept(cx + x, cx + i);
                    drawPixel.accept(cx - x, cx + i);
                }
            } else {
                drawPixel.accept(cx + x, cy + y);
                drawPixel.accept(cx - x, cy + y);
                drawPixel.accept(cx + x, cy - y);
                drawPixel.accept(cx - x, cy - y);
            }
            if (sigma >= 0) {
                sigma += 4 * ry2 * (1 - x);
                --x;
            }
            sigma += rx2 * (4 * y + 6);
            ++y;
        }
    }

    public static void drawLine(int x1, int y1, int x2, int y2, BiConsumer<Integer, Integer> drawPixel) {
        int dy;
        int currentX = x1;
        int currentY = y1;
        int dx = Math.abs(x2 - x1);
        int error = (dx > (dy = Math.abs(y2 - y1)) ? dx : -dy) / 2;
        while (true) {
            drawPixel.accept(currentX, currentY);
            if (currentX == x2 && currentY == y2 || Math.abs(currentX - x1) > Math.abs(x2 - x1) || Math.abs(currentY - y1) > Math.abs(y2 - y1)) break;
            if (error * 2 > -dx) {
                error -= dy;
                currentX += x1 < x2 ? 1 : -1;
            }
            if (error * 2 >= dy) continue;
            error += dx;
            currentY += y1 < y2 ? 1 : -1;
        }
    }

    public static void drawSphere(BlockPos radius, BlockPos center, boolean filled, Consumer<BlockPos> drawPixel) {
        double nextNx = 0.0;
        block0: for (int x = 0; x <= radius.func_177958_n(); ++x) {
            double nx = nextNx;
            nextNx = (double)(x + 1) * (1.0 / (double)radius.func_177958_n());
            double nextNy = 0.0;
            block1: for (int y = 0; y <= radius.func_177956_o(); ++y) {
                double ny = nextNy;
                nextNy = (double)(y + 1) * (1.0 / (double)radius.func_177956_o());
                double nextNz = 0.0;
                for (int z = 0; z <= radius.func_177952_p(); ++z) {
                    double nz = nextNz;
                    nextNz = (double)(z + 1) * (1.0 / (double)radius.func_177952_p());
                    if (nx * nx + ny * ny + nz * nz > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        if (x != 0) break block0;
                    }
                    if (!filled && nextNx * nextNx + ny * ny + nz * nz <= 1.0 && nx * nx + nextNy * nextNy + nz * nz <= 1.0 && nx * nx + ny * ny + nextNz * nextNz <= 1.0) continue;
                    drawPixel.accept(center.func_177982_a(-x, -y, -z));
                    drawPixel.accept(center.func_177982_a(-x, -y, z));
                    drawPixel.accept(center.func_177982_a(-x, y, -z));
                    drawPixel.accept(center.func_177982_a(-x, y, z));
                    drawPixel.accept(center.func_177982_a(x, -y, -z));
                    drawPixel.accept(center.func_177982_a(x, -y, z));
                    drawPixel.accept(center.func_177982_a(x, y, -z));
                    drawPixel.accept(center.func_177982_a(x, y, z));
                }
            }
        }
    }

    public static void fill(boolean[][] data, int startX, int startY, int width, int height) {
        ArrayDeque<Point2i> queue = new ArrayDeque<Point2i>();
        queue.add(new Point2i(startX, startY));
        while (!queue.isEmpty()) {
            Point2i point = (Point2i)queue.poll();
            if (point.x < 0 || point.y < 0 || point.x >= width || point.y >= height || data[point.x][point.y]) continue;
            data[point.x][point.y] = true;
            queue.add(new Point2i(point.x - 1, point.y));
            queue.add(new Point2i(point.x + 1, point.y));
            queue.add(new Point2i(point.x, point.y - 1));
            queue.add(new Point2i(point.x, point.y + 1));
        }
    }
}

