/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.json;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.InternalCompiler;
import buildcraft.lib.expression.api.IConstantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.value.ITickableNode;
import buildcraft.lib.expression.node.value.NodeStateful;
import buildcraft.lib.expression.node.value.NodeUpdatable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.JsonUtils;

public class JsonVariableObject {
    public Map<String, ITickableNode.Source> variables = new LinkedHashMap<String, ITickableNode.Source>();
    private ITickableNode.Source[] variablesArray;

    protected void putVariables(JsonObject values, FunctionContext fnCtx) {
        for (Map.Entry entry : values.entrySet()) {
            IExpressionNode node;
            String name = (String)entry.getKey();
            if (fnCtx.hasLocalVariable(name = name.toLowerCase(Locale.ROOT))) {
                throw new JsonSyntaxException("Duplicate local variable '" + name + "'");
            }
            if (fnCtx.getVariable(name) != null) continue;
            JsonElement value = (JsonElement)entry.getValue();
            String type = null;
            String getter = null;
            String rounder = null;
            if (value.isJsonObject()) {
                JsonObject objValue = value.getAsJsonObject();
                value = objValue.get("value");
                type = JsonUtils.func_151200_h((JsonObject)objValue, (String)"type");
                getter = JsonUtils.func_151200_h((JsonObject)objValue, (String)"getter");
                if (objValue.has("rounder")) {
                    rounder = JsonUtils.func_151200_h((JsonObject)objValue, (String)"rounder");
                }
            }
            if (!value.isJsonPrimitive()) {
                throw new JsonSyntaxException("Expected a primitive, got " + value + " for the variable '" + name + "'");
            }
            NodeStateful stateful = null;
            FunctionContext fnCtxValue = new FunctionContext("Value Object", fnCtx);
            if (getter != null) {
                Class<?> nodeType;
                try {
                    nodeType = NodeTypes.parseType(type);
                }
                catch (InvalidExpressionException iee) {
                    throw new JsonSyntaxException("Could not parse node type for variable '" + name + "'", (Throwable)iee);
                }
                NodeStateful.IGetterFunc getterFunc = JsonVariableObject.parseGetterFunction(getter, fnCtx);
                try {
                    stateful = new NodeStateful(name, nodeType, getterFunc);
                }
                catch (InvalidExpressionException iee) {
                    throw new JsonSyntaxException("Could not create a getter for the variable '" + name + "'", (Throwable)iee);
                }
                fnCtx.putVariable(name, stateful.getter);
                fnCtxValue.putVariable(name, stateful.variable);
                if (rounder != null) {
                    FunctionContext fnCtx2 = new FunctionContext("Rounding", fnCtx);
                    fnCtx2.putVariable("last", stateful.last);
                    fnCtx2.putVariable("current", stateful.variable);
                    fnCtx2.putVariable("value", stateful.rounderValue);
                    try {
                        IExpressionNode nodeRounder = InternalCompiler.compileExpression(rounder, fnCtx2);
                        stateful.setRounder(nodeRounder);
                    }
                    catch (InvalidExpressionException iee) {
                        throw new JsonSyntaxException("Could not compile a rounder for the variable '" + name + "'", (Throwable)iee);
                    }
                }
            }
            String expression = value.getAsString();
            try {
                node = InternalCompiler.compileExpression(expression, fnCtxValue);
            }
            catch (InvalidExpressionException e) {
                throw new JsonSyntaxException("Failed to compile variable " + name, (Throwable)e);
            }
            if (node instanceof IConstantNode) {
                fnCtx.putVariable(name, node);
                continue;
            }
            if (this.variables.containsKey(name)) {
                ITickableNode.Source existing = this.variables.get(name);
                existing.setSource(node);
                continue;
            }
            if (stateful != null) {
                stateful.setSource(node);
                this.variables.put(name, stateful);
                continue;
            }
            NodeUpdatable nodeUpdatable = new NodeUpdatable(name, node);
            this.variables.put(name, nodeUpdatable);
            fnCtx.putVariable(name, nodeUpdatable.variable);
        }
    }

    private static NodeStateful.IGetterFunc parseGetterFunction(String getter, FunctionContext fnCtx) {
        if ("interpolate_partial_ticks".equalsIgnoreCase(getter)) {
            return NodeStateful.GetterType.INTERPOLATE_PARTIAL_TICKS;
        }
        if ("last".equalsIgnoreCase(getter)) {
            return NodeStateful.GetterType.USE_LAST;
        }
        if ("var".equalsIgnoreCase(getter)) {
            return NodeStateful.GetterType.USE_VAR;
        }
        return (var, last) -> {
            FunctionContext fnCtx2 = new FunctionContext("Getters", fnCtx);
            fnCtx2.putVariable("var", var);
            fnCtx2.putVariable("last", last);
            return InternalCompiler.compileExpression(getter, fnCtx2);
        };
    }

    protected void finaliseVariables() {
        this.variablesArray = this.variables.values().toArray(new ITickableNode.Source[0]);
    }

    public ITickableNode[] createTickableNodes() {
        ITickableNode[] nodes = new ITickableNode[this.variablesArray.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = this.variablesArray[i].createTickable();
        }
        return nodes;
    }
}

