/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.config.GuiConfigManager;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.gui.json.ElementType;
import buildcraft.lib.gui.json.JsonGuiElement;
import buildcraft.lib.gui.json.JsonGuiInfo;
import buildcraft.lib.gui.ledger.Ledger_Neptune;
import buildcraft.lib.gui.pos.IGuiPosition;
import net.minecraft.util.ResourceLocation;

public class ElementTypeLedger
extends ElementType {
    public static final String NAME = "buildcraftlib:ledger";
    public static final ElementTypeLedger INSTANCE = new ElementTypeLedger();

    private ElementTypeLedger() {
        super(NAME);
    }

    @Override
    public IGuiElement deserialize0(BuildCraftJsonGui gui, IGuiPosition parent, JsonGuiInfo info, JsonGuiElement json) {
        FunctionContext ctx = ElementTypeLedger.createContext(json);
        ElementTypeLedger.inheritProperty(json, "color", "colour");
        String side = json.properties.get("side");
        String title = json.properties.get("title");
        int colour = ElementTypeLedger.resolveEquationInt(json, "colour", ctx);
        boolean positive = "right".equalsIgnoreCase(side);
        Ledger_Neptune ledger = new Ledger_Neptune(gui, colour, positive);
        ledger.setTitle(title);
        ElementTypeLedger.addChildren(gui, ledger.positionLedgerIconStart, info, json, "closed", ledger.getClosedElements()::add);
        ledger.calculateMaxSize();
        ResourceLocation def = gui.jsonGuiDefinition;
        def = new ResourceLocation(def.func_110624_b(), def.func_110623_a().replace(".json", ""));
        ledger.setOpenProperty(GuiConfigManager.getOrAddBoolean(def, json.name + ".is_open", false));
        return ledger;
    }
}

