/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.help.DummyHelpElement;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.gui.json.ElementType;
import buildcraft.lib.gui.json.JsonGuiElement;
import buildcraft.lib.gui.json.JsonGuiInfo;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import java.util.ArrayList;

public class ElementTypeHelp
extends ElementType {
    public static final String NAME = "buildcraftlib:help";
    public static final ElementTypeHelp INSTANCE = new ElementTypeHelp();

    private ElementTypeHelp() {
        super(NAME);
    }

    @Override
    public IGuiElement deserialize0(BuildCraftJsonGui gui, IGuiPosition parent, JsonGuiInfo info, JsonGuiElement json) {
        FunctionContext ctx = ElementTypeHelp.createContext(json);
        String title = json.properties.get("title");
        ArrayList<String> text = new ArrayList<String>();
        if (json.properties.containsKey("text[0]")) {
            String prop;
            int i = 0;
            while ((prop = json.properties.get("text[" + i + "]")) != null) {
                text.add(prop);
                ++i;
            }
        } else {
            text.add(json.properties.getOrDefault("text", "ERROR: Help not given!"));
        }
        int colour = ElementTypeHelp.resolveEquationInt(json, "colour", ctx);
        ElementHelpInfo help = new ElementHelpInfo(title, colour, text.toArray(new String[0]));
        ElementTypeHelp.inheritProperty(json, "pos[0]", "area[0]");
        ElementTypeHelp.inheritProperty(json, "pos[1]", "area[1]");
        ElementTypeHelp.inheritProperty(json, "size[0]", "area[2]");
        ElementTypeHelp.inheritProperty(json, "size[1]", "area[3]");
        IGuiArea area = ElementTypeHelp.resolveArea(json, "area", parent, ctx);
        return new DummyHelpElement(area, help);
    }
}

