/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.fluid;

import buildcraft.lib.fluid.BCFluid;
import buildcraft.lib.fluid.BCFluidBlock;
import buildcraft.lib.fluid.BCMaterialFluid;
import buildcraft.lib.registry.RegistrationHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidManager {
    private static final RegistrationHelper HELPER = new RegistrationHelper();
    private static final List<BCFluidBlock> fluidBlocks = new ArrayList<BCFluidBlock>();

    public static <F extends BCFluid> F register(F fluid) {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new IllegalStateException("Can only call this during pre-init!");
        }
        FluidRegistry.registerFluid(fluid);
        BCMaterialFluid material = new BCMaterialFluid(fluid.getMapColour(), fluid.isFlammable());
        BCFluidBlock block = new BCFluidBlock(fluid, (Material)material);
        block.setRegistryName(Loader.instance().activeModContainer().getModId(), "fluid_block_" + fluid.getBlockName());
        block.func_149663_c("blockFluid_" + fluid.getBlockName());
        block.func_149713_g(fluid.getLightOpacity());
        HELPER.addForcedBlock(block);
        fluid.setBlock((Block)block);
        FluidRegistry.addBucketForFluid(fluid);
        fluidBlocks.add(block);
        return fluid;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelBake(ModelBakeEvent event) {
        for (BCFluidBlock fluid : fluidBlocks) {
            event.getModelManager().func_174954_c().func_178121_a((Block)fluid, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidBase.LEVEL}).func_178441_a());
        }
    }
}

