/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression;

import java.util.Locale;

public class Argument {
    public final String name;
    public final Class<?> type;

    public Argument(String name, Class<?> type) {
        this.name = name;
        this.type = type;
    }

    public static Argument argLong(String name) {
        return new Argument(name, Long.TYPE);
    }

    public static Argument argDouble(String name) {
        return new Argument(name, Double.TYPE);
    }

    public static Argument argBoolean(String name) {
        return new Argument(name, Boolean.TYPE);
    }

    public static Argument argString(String name) {
        return new Argument(name, String.class);
    }

    public static Argument argObject(String name, Class<?> type) {
        return new Argument(name, type);
    }

    public String toString() {
        return this.type.getSimpleName().toLowerCase(Locale.ROOT) + " '" + this.name + "'";
    }
}

