/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render.laser;

import buildcraft.lib.client.render.laser.CompiledLaserType;
import buildcraft.lib.client.render.laser.ILaserRenderer;
import buildcraft.lib.client.render.laser.LaserCompiledBuffer;
import buildcraft.lib.client.render.laser.LaserCompiledList;
import buildcraft.lib.client.render.laser.LaserContext;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.misc.SpriteUtil;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalNotification;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LaserRenderer_BC8 {
    private static final Map<LaserData_BC8.LaserType, CompiledLaserType> COMPILED_LASER_TYPES = new HashMap<LaserData_BC8.LaserType, CompiledLaserType>();
    private static final LoadingCache<LaserData_BC8, LaserCompiledList> COMPILED_STATIC_LASERS = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).removalListener(LaserRenderer_BC8::removeCompiledLaser).build(CacheLoader.from(LaserRenderer_BC8::makeStaticLaser));
    private static final LoadingCache<LaserData_BC8, LaserCompiledBuffer> COMPILED_DYNAMIC_LASERS = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build(CacheLoader.from(LaserRenderer_BC8::makeDynamicLaser));
    public static final VertexFormat FORMAT_LESS = new VertexFormat();
    public static final VertexFormat FORMAT_ALL;

    public static void clearModels() {
        COMPILED_LASER_TYPES.clear();
    }

    private static CompiledLaserType compileType(LaserData_BC8.LaserType laserType) {
        if (!COMPILED_LASER_TYPES.containsKey(laserType)) {
            COMPILED_LASER_TYPES.put(laserType, new CompiledLaserType(laserType));
        }
        return COMPILED_LASER_TYPES.get(laserType);
    }

    private static LaserCompiledList makeStaticLaser(LaserData_BC8 data) {
        try (LaserCompiledList.Builder renderer = new LaserCompiledList.Builder(data.enableDiffuse);){
            LaserRenderer_BC8.makeLaser(data, renderer);
            LaserCompiledList laserCompiledList = renderer.build();
            return laserCompiledList;
        }
    }

    private static LaserCompiledBuffer makeDynamicLaser(LaserData_BC8 data) {
        LaserCompiledBuffer.Builder renderer = new LaserCompiledBuffer.Builder(data.enableDiffuse);
        LaserRenderer_BC8.makeLaser(data, renderer);
        return renderer.build();
    }

    private static void makeLaser(LaserData_BC8 data, ILaserRenderer renderer) {
        LaserContext ctx = new LaserContext(renderer, data, data.enableDiffuse, data.doubleFace);
        CompiledLaserType type = LaserRenderer_BC8.compileType(data.laserType);
        type.bakeFor(ctx);
    }

    private static void removeCompiledLaser(RemovalNotification<LaserData_BC8, LaserCompiledList> notification) {
        LaserCompiledList comp = (LaserCompiledList)notification.getValue();
        if (comp != null) {
            comp.delete();
        }
    }

    public static int computeLightmap(double x, double y, double z, int minBlockLight) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return 0;
        }
        int blockLight = minBlockLight >= 15 ? 15 : Math.max(minBlockLight, LaserRenderer_BC8.getLightFor((World)world, EnumSkyBlock.BLOCK, x, y, z));
        int skyLight = LaserRenderer_BC8.getLightFor((World)world, EnumSkyBlock.SKY, x, y, z);
        return skyLight << 20 | blockLight << 4;
    }

    private static int getLightFor(World world, EnumSkyBlock type, double x, double y, double z) {
        int yu;
        int xu;
        int zl;
        int yl;
        int xl;
        int max = 0;
        int count = 0;
        int sum = 0;
        boolean ao = Minecraft.func_71379_u();
        double xn = (x % 1.0 + 1.0) % 1.0;
        double yn = (y % 1.0 + 1.0) % 1.0;
        double zn = (z % 1.0 + 1.0) % 1.0;
        double lowerBound = 0.3;
        double upperBound = 0.7;
        int n = ao ? (xn < 0.3 ? -1 : 0) : (xl = -1);
        int n2 = ao ? (yn < 0.3 ? -1 : 0) : (yl = -1);
        int n3 = ao ? (zn < 0.3 ? -1 : 0) : (zl = -1);
        int n4 = ao ? (xn > 0.7 ? 1 : 0) : (xu = 1);
        int n5 = ao ? (yn > 0.7 ? 1 : 0) : (yu = 1);
        int zu = ao ? (zn > 0.7 ? 1 : 0) : 1;
        for (int xp = xl; xp <= xu; ++xp) {
            for (int yp = yl; yp <= yu; ++yp) {
                for (int zp = zl; zp <= zu; ++zp) {
                    int light = world.func_175642_b(type, new BlockPos(x + (double)xp, y + (double)yp, z + (double)zp));
                    if (light > 0) {
                        sum += light;
                        ++count;
                    }
                    max = Math.max(max, light);
                }
            }
        }
        if (ao) {
            return count == 0 ? 0 : sum / count;
        }
        return max;
    }

    public static void renderLaserStatic(LaserData_BC8 data) {
        Profiler profiler = Minecraft.func_71410_x().field_71424_I;
        profiler.func_76320_a("compute");
        LaserCompiledList compiled = (LaserCompiledList)COMPILED_STATIC_LASERS.getUnchecked((Object)data);
        profiler.func_76318_c("render");
        SpriteUtil.bindBlockTextureMap();
        compiled.render();
        profiler.func_76319_b();
    }

    public static void renderLaserDynamic(LaserData_BC8 data, BufferBuilder buffer) {
        Profiler profiler = Minecraft.func_71410_x().field_71424_I;
        profiler.func_76320_a("compute");
        LaserCompiledBuffer compiled = (LaserCompiledBuffer)COMPILED_DYNAMIC_LASERS.getUnchecked((Object)data);
        profiler.func_76318_c("render");
        compiled.render(buffer);
        profiler.func_76319_b();
    }

    static {
        FORMAT_LESS.func_181721_a(DefaultVertexFormats.field_181713_m);
        FORMAT_LESS.func_181721_a(DefaultVertexFormats.field_181715_o);
        FORMAT_LESS.func_181721_a(DefaultVertexFormats.field_181716_p);
        FORMAT_ALL = new VertexFormat();
        FORMAT_ALL.func_181721_a(DefaultVertexFormats.field_181713_m);
        FORMAT_ALL.func_181721_a(DefaultVertexFormats.field_181715_o);
        FORMAT_ALL.func_181721_a(DefaultVertexFormats.field_181716_p);
        FORMAT_ALL.func_181721_a(DefaultVertexFormats.field_181714_n);
    }
}

