/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.json;

import buildcraft.lib.client.model.ResourceLoaderContext;
import buildcraft.lib.client.model.json.JsonQuad;
import buildcraft.lib.misc.JsonUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;

public class JsonModelPart {
    public final JsonQuad[] quads;

    public JsonModelPart(JsonElement json, ResourceLoaderContext ctx) {
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected an object, got " + json);
        }
        JsonObject obj = json.getAsJsonObject();
        String type = "cuboid";
        if (obj.has("type")) {
            JsonElement jType = obj.get("type");
            if (jType.isJsonPrimitive()) {
                JsonPrimitive prim = jType.getAsJsonPrimitive();
                type = prim.getAsString();
            } else {
                throw new JsonSyntaxException("Expected a string, got " + jType);
            }
        }
        this.quads = "face".equals(type) ? JsonModelPart.readFace(obj) : JsonModelPart.readCuboid(obj);
    }

    private JsonModelPart(JsonQuad[] quads) {
        this.quads = quads;
    }

    private static JsonQuad[] readFace(JsonObject obj) {
        throw new AbstractMethodError("Implement this!");
    }

    private static float[] readFloatPositionSmaller(JsonObject obj, String member) {
        float[] got = JsonUtil.getSubAsFloatArray(obj, member);
        if (got.length != 3) {
            throw new JsonSyntaxException("Expected exactly 3 floats, but got " + Arrays.toString(got));
        }
        got[0] = got[0] / 16.0f;
        got[1] = got[1] / 16.0f;
        got[2] = got[2] / 16.0f;
        return got;
    }

    private static JsonQuad[] readCuboid(JsonObject obj) {
        float[] from = JsonModelPart.readFloatPositionSmaller(obj, "from");
        float[] to = JsonModelPart.readFloatPositionSmaller(obj, "to");
        boolean shade = JsonUtils.func_151209_a((JsonObject)obj, (String)"shade", (boolean)false);
        if (obj.has("faces")) {
            JsonElement faces = obj.get("faces");
            if (faces.isJsonObject()) {
                JsonObject jFaces = faces.getAsJsonObject();
                ArrayList<JsonQuad> quads = new ArrayList<JsonQuad>();
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    if (!jFaces.has(face.func_176610_l())) continue;
                    JsonElement jFace = jFaces.get(face.func_176610_l());
                    if (!jFace.isJsonObject()) {
                        throw new JsonSyntaxException("Expected an object, but got " + jFace);
                    }
                    JsonQuad q = new JsonQuad(jFace.getAsJsonObject(), from, to, face);
                    q.shade = shade;
                    quads.add(q);
                }
                if (quads.size() == 0) {
                    throw new JsonSyntaxException("Expected between 1 and 6 faces, got an empty object " + jFaces);
                }
                return quads.toArray(new JsonQuad[quads.size()]);
            }
            throw new JsonSyntaxException("Expected between 1 and 6 faces, got " + faces);
        }
        throw new JsonSyntaxException("Expected between 1 and 6 faces, got nothing");
    }
}

