/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.contents;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.GuideText;
import buildcraft.lib.client.guide.parts.contents.IContentsLeaf;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class PageLink
implements IContentsLeaf {
    public final PageLine text;
    public final boolean startVisible;
    private final String lowerCaseName;
    private boolean visible;

    public PageLink(PageLine text, boolean startVisible) {
        this.text = text;
        this.startVisible = startVisible;
        this.lowerCaseName = text.text.toLowerCase(Locale.ROOT);
        this.visible = startVisible;
    }

    @Override
    public String getSearchName() {
        return this.lowerCaseName;
    }

    @Nullable
    protected List<String> getTooltip() {
        return null;
    }

    public void appendTooltip(GuiGuide gui) {
        List<String> tooltip = this.getTooltip();
        if (tooltip != null && !tooltip.isEmpty()) {
            gui.tooltips.add(tooltip);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(Set<PageLink> matches) {
        this.visible = matches.contains(this);
    }

    @Override
    public void resetVisibility() {
        this.visible = this.startVisible;
    }

    @Override
    public GuidePart createGuidePart(GuiGuide gui) {
        return new GuideText(gui, this.text){

            @Override
            protected void renderTooltip() {
                PageLink.this.appendTooltip(this.gui);
            }
        };
    }

    public abstract GuidePageFactory getFactoryLink();
}

