/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.sprite.SpriteNineSliced;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.misc.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class GuideChapter
extends GuidePart {
    public static final int[] COLOURS = new int[]{10343872, 16433524, 2598109};
    public static final int MAX_HOWEVER_PROGRESS = 5;
    public static final int MAX_HOVER_DISTANCE = 20;
    private static final boolean FOLLOW_SIDE = false;
    public final PageLine chapter;
    public final int level;
    private int hoverProgress = 0;
    private int hoverProgressLast = 0;
    protected EnumGuiSide lastDrawn = null;
    private boolean expanded = false;
    @Nullable
    protected GuideChapter parent;
    protected final List<GuideChapter> children = new ArrayList<GuideChapter>();
    protected int colourIndex = -1;

    public GuideChapter(GuiGuide gui, String chapter) {
        this(gui, 0, chapter);
    }

    public GuideChapter(GuiGuide gui, int level, String text) {
        super(gui);
        ISimpleDrawable icon = (x, y) -> {
            GuiGuide.BOX_EMPTY.drawAt(x, y);
            RenderUtil.setGLColorFromInt(this.getColour());
            GuiGuide.BOX_CHAPTER.drawAt(x, y);
            RenderUtil.setGLColorFromInt(-1);
        };
        ISimpleDrawable selected = (x, y) -> {
            GuiGuide.BOX_SELECTED_EMPTY.drawAt(x, y);
            RenderUtil.setGLColorFromInt(this.getColour());
            GuiGuide.BOX_SELECTED_CHAPTER.drawAt(x, y);
            RenderUtil.setGLColorFromInt(-1);
        };
        this.level = Math.max(0, level);
        icon = null;
        selected = null;
        this.chapter = new PageLine(icon, selected, this.level + 1, text, false);
    }

    private int getColour() {
        if (this.colourIndex < 0) {
            return this.chapter.text.hashCode();
        }
        return COLOURS[this.colourIndex % COLOURS.length];
    }

    public void reset() {
        this.lastDrawn = EnumGuiSide.LEFT;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    void assignChildIndices() {
        int cIdx = 0;
        for (GuideChapter child : this.children) {
            if (cIdx % COLOURS.length == this.colourIndex) {
                // empty if block
            }
            int n = ++cIdx;
            ++cIdx;
            child.colourIndex = n % COLOURS.length;
            if (!child.hasChildren()) continue;
            child.assignChildIndices();
        }
    }

    @Override
    public GuidePart.PagePosition renderIntoArea(int x, int y, int width, int height, GuidePart.PagePosition current, int index) {
        current = current.guaranteeSpace(this.getFontRenderer().getMaxFontHeight() * 4, height);
        int colour = this.getColour();
        if (current.page == index) {
            RenderUtil.setGLColorFromInt(colour);
            int _x = x + 12;
            int _y = y + current.pixel;
            GuidePart.PagePosition n2 = this.renderLine(current, this.chapter, x, y, width, height, -1);
            int _height = n2.pixel - current.pixel;
            GuiGuide.CHAPTER_MARKER_9.draw(_x - 5, _y - 4, width - 24, _height);
            RenderUtil.setGLColorFromInt(-1);
        }
        GuidePart.PagePosition n = this.renderLine(current, this.chapter, x, y, width, height, index);
        if (n.page / 2 < (index /= 2)) {
            this.lastDrawn = EnumGuiSide.LEFT;
        } else if (index == current.page / 2 || index == current.page / 2) {
            this.lastDrawn = EnumGuiSide.LEFT;
        }
        if (this.lastDrawn != null && this.parent != null) {
            GuideChapter p = this.parent;
            while (p != null) {
                if (p.lastDrawn == null) {
                    p.lastDrawn = this.lastDrawn;
                }
                p = p.parent;
            }
        }
        return n;
    }

    @Override
    public GuidePart.PagePosition handleMouseClick(int x, int y, int width, int height, GuidePart.PagePosition current, int index, int mouseX, int mouseY) {
        current = current.guaranteeSpace(this.getFontRenderer().getMaxFontHeight() * 4, height);
        return this.renderLine(current, this.chapter, x, y, width, height, -1);
    }

    public int draw(int yIndex, float partialTicks, boolean drawCentral) {
        int drawnCount = 1;
        IFontRenderer font = this.gui.getCurrentFont();
        String text = this.chapter.text;
        float hoverWidth = this.getHoverWidth(partialTicks);
        float width = (float)font.getStringWidth(text) + hoverWidth;
        int colour = this.getColour();
        int baseY = drawCentral ? (int)GuiGuide.FLOATING_CHAPTER_MENU.getY() + 6 : this.gui.minY;
        int y = baseY + (font.getMaxFontHeight() + 8) * (yIndex + 1);
        boolean hasChildren = !this.children.isEmpty();
        float _width = (float)(font.getStringWidth(text) + 12) + hoverWidth + (float)(hasChildren ? 16 : 0);
        int fullHeight = font.getFontHeight(text) + 6;
        int childHeight = 0;
        if (hasChildren && this.expanded) {
            childHeight = fullHeight + this.getChildrenFullHeight();
        }
        if (drawCentral || this.lastDrawn == EnumGuiSide.RIGHT) {
            SpriteNineSliced icon;
            float x;
            if (drawCentral) {
                x = (float)GuiGuide.FLOATING_CHAPTER_MENU.getX() + 4.0f + hoverWidth;
                _width -= hoverWidth;
                hoverWidth = 0.0f;
            } else {
                x = this.gui.minX + GuiGuide.PAGE_LEFT.width + GuiGuide.PAGE_RIGHT.width - 11;
            }
            x += (float)(this.level * 14);
            GuideChapter p = this.parent;
            while (p != null) {
                x += p.getHoverWidth(partialTicks);
                p = p.parent;
            }
            RenderUtil.setGLColorFromInt(colour);
            SpriteNineSliced spriteNineSliced = icon = drawCentral ? GuiGuide.CHAPTER_MARKER_9 : GuiGuide.CHAPTER_MARKER_9_RIGHT;
            if (childHeight > 0) {
                icon.draw(x + 10.0f, y + fullHeight - 12, _width - 16.0f, childHeight);
            }
            icon.draw(x, y - 4, _width, fullHeight);
            if (hasChildren) {
                (this.expanded ? GuiGuide.EXPANDED_ARROW : GuiGuide.CLOSED_ARROW).drawAt(x + hoverWidth, y - 4);
                x += 16.0f;
                if (this.expanded) {
                    for (GuideChapter child : this.children) {
                        EnumGuiSide old = child.lastDrawn;
                        child.lastDrawn = this.lastDrawn;
                        drawnCount += child.draw(yIndex + drawnCount, partialTicks, drawCentral);
                        child.lastDrawn = old;
                    }
                }
            }
            RenderUtil.setGLColorFromInt(-1);
            font.drawString(text, (int)(x + 6.0f + hoverWidth), y, 0);
        } else if (this.lastDrawn == EnumGuiSide.LEFT) {
            float x = (float)this.gui.minX - width + 5.0f;
            if (hasChildren) {
                x -= 16.0f;
            }
            RenderUtil.setGLColorFromInt(colour);
            if (childHeight > 0) {
                GuiGuide.CHAPTER_MARKER_9_LEFT.draw(x + 10.0f, y + fullHeight - 12, _width - 16.0f, childHeight);
            }
            GuiGuide.CHAPTER_MARKER_9_LEFT.draw(x - 6.0f, y - 4, _width, fullHeight);
            if (hasChildren) {
                (this.expanded ? GuiGuide.EXPANDED_ARROW : GuiGuide.CLOSED_ARROW).drawAt(x - 6.0f, y - 4);
                x += 16.0f;
                if (this.expanded) {
                    for (GuideChapter child : this.children) {
                        EnumGuiSide old = child.lastDrawn;
                        child.lastDrawn = this.lastDrawn;
                        drawnCount += child.draw(yIndex + drawnCount, partialTicks, drawCentral);
                        child.lastDrawn = old;
                    }
                }
            }
            RenderUtil.setGLColorFromInt(-1);
            font.drawString(text, (int)x, y, 0);
        }
        return drawnCount;
    }

    private int getChildrenFullHeight() {
        if (!this.expanded) {
            return 0;
        }
        int fullHeight = 0;
        IFontRenderer font = this.gui.getCurrentFont();
        for (GuideChapter c : this.children) {
            fullHeight += font.getFontHeight(c.chapter.text) + 6;
            fullHeight += c.getChildrenFullHeight();
            fullHeight += 2;
        }
        return fullHeight;
    }

    protected int getMousePart() {
        int x;
        GuiRectangle drawRect;
        boolean isCentral;
        float hoverWidth;
        IFontRenderer font = this.gui.getCurrentFont();
        String text = this.chapter.text;
        float realHoverWidth = hoverWidth = this.getHoverWidth(0.0f);
        int width = (int)((float)font.getStringWidth(text) + hoverWidth) + (this.children.isEmpty() ? 0 : 16);
        int chapterIndex = 0;
        GuideChapter p = this.parent;
        while (p != null) {
            if (!p.expanded) {
                return 0;
            }
            p = p.parent;
        }
        block1: for (GuideChapter c : this.gui.getChapters()) {
            ++chapterIndex;
            if (c == this) break;
            p = c.parent;
            while (p != null) {
                if (!p.expanded) {
                    --chapterIndex;
                    continue block1;
                }
                p = p.parent;
            }
        }
        int baseY = (isCentral = this.gui.isSmallScreen()) ? (int)GuiGuide.FLOATING_CHAPTER_MENU.getY() + 6 : this.gui.minY;
        int y = baseY + (font.getMaxFontHeight() + 8) * chapterIndex;
        if (isCentral || this.lastDrawn == EnumGuiSide.RIGHT) {
            int x2;
            if (isCentral) {
                x2 = (int)GuiGuide.FLOATING_CHAPTER_MENU.getX() + 4 + (int)hoverWidth;
                width = (int)((float)width - hoverWidth);
                hoverWidth = 0.0f;
            } else {
                x2 = this.gui.minX + GuiGuide.PAGE_LEFT.width + GuiGuide.PAGE_RIGHT.width - 11;
            }
            x2 += this.level * 14;
            p = this.parent;
            while (p != null) {
                x2 = (int)((float)x2 + p.getHoverWidth(0.0f));
                p = p.parent;
            }
            GuiRectangle drawRect2 = new GuiRectangle((float)x2 - realHoverWidth, y - 4, width + 16, 16.0);
            if (drawRect2.contains(this.gui.mouse)) {
                GuiRectangle arrowRect = new GuiRectangle((float)x2 - realHoverWidth, y - 4, 24.0f + realHoverWidth, 16.0);
                if (this.hasChildren() && arrowRect.contains(this.gui.mouse)) {
                    return 2;
                }
                return 1;
            }
        } else if (this.lastDrawn == EnumGuiSide.LEFT && (drawRect = new GuiRectangle(x = this.gui.minX - width - 5, y - 4, width + 16, 16.0)).contains(this.gui.mouse)) {
            if (this.hasChildren() && new GuiRectangle(x, y - 4, 24.0, 16.0).contains(this.gui.mouse)) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private float getHoverWidth(float partialTicks) {
        float prog = partialTicks * (float)this.hoverProgress + (1.0f - partialTicks) * (float)this.hoverProgressLast;
        return prog * 20.0f / 5.0f;
    }

    public int handleClick() {
        int part = this.getMousePart();
        if (part == 1) {
            return this.onClick() ? 1 : 0;
        }
        if (part == 2) {
            this.expanded = !this.expanded;
            return 2;
        }
        return 0;
    }

    protected abstract boolean onClick();

    @Override
    public void updateScreen() {
        this.hoverProgressLast = this.hoverProgress--;
        if (this.getMousePart() != 0) {
            this.hoverProgress += 2;
            if (this.hoverProgress > 5) {
                this.hoverProgress = 5;
            }
        } else if (this.hoverProgress < 0) {
            this.hoverProgress = 0;
        }
    }

    public static enum EnumGuiSide {
        LEFT,
        RIGHT;

    }
}

