/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.cache;

import buildcraft.lib.cache.IChunkCache;
import buildcraft.lib.misc.ChunkUtil;
import java.lang.ref.WeakReference;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class CachedChunk
implements IChunkCache {
    private final TileEntity tile;
    private WeakReference<Chunk> cachedChunk;

    public CachedChunk(TileEntity tile) {
        this.tile = tile;
    }

    @Override
    public void invalidate() {
        this.cachedChunk = null;
    }

    @Override
    public Chunk getChunk(BlockPos pos) {
        World world;
        if (this.tile.func_145837_r()) {
            this.cachedChunk = null;
            return null;
        }
        BlockPos tPos = this.tile.func_174877_v();
        if (pos.func_177958_n() >> 4 != tPos.func_177958_n() >> 4 || pos.func_177952_p() >> 4 != tPos.func_177952_p() >> 4) {
            return null;
        }
        if (this.cachedChunk != null) {
            Chunk c = (Chunk)this.cachedChunk.get();
            if (c != null && c.func_177410_o()) {
                return c;
            }
            this.cachedChunk = null;
        }
        if ((world = this.tile.func_145831_w()) == null) {
            this.cachedChunk = null;
            return null;
        }
        Chunk chunk = ChunkUtil.getChunk(world, pos, true);
        if (chunk != null && chunk.func_177412_p() == world) {
            this.cachedChunk = new WeakReference<Chunk>(chunk);
            return chunk;
        }
        return null;
    }
}

