/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.client;

import buildcraft.api.core.IBox;
import buildcraft.api.items.IMapLocation;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.core.BCCoreItems;
import buildcraft.core.client.BuildCraftLaserManager;
import buildcraft.core.item.ItemMapLocation;
import buildcraft.core.item.ItemMarkerConnector;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.client.render.laser.LaserBoxRenderer;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.client.render.laser.LaserRenderer_BC8;
import buildcraft.lib.debug.ClientDebuggables;
import buildcraft.lib.marker.MarkerCache;
import buildcraft.lib.marker.MarkerSubCache;
import buildcraft.lib.misc.MatrixUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.Box;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class RenderTickListener {
    private static final Vec3d[][][] MAP_LOCATION_POINT = new Vec3d[6][][];
    private static final String DIFF_START;
    private static final String DIFF_HEADER_FORMATTING;
    private static final Box LAST_RENDERED_MAP_LOC;

    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        IDebuggable debuggable = ClientDebuggables.getDebuggableObject(mc.field_71476_x);
        if (debuggable != null) {
            ArrayList<String> clientLeft = new ArrayList<String>();
            ArrayList<String> clientRight = new ArrayList<String>();
            debuggable.getDebugInfo(clientLeft, clientRight, mc.field_71476_x.field_178784_b);
            String headerFirst = DIFF_HEADER_FORMATTING + "SERVER:";
            String headerSecond = DIFF_HEADER_FORMATTING + "CLIENT:";
            RenderTickListener.appendDiff(event.getLeft(), ClientDebuggables.SERVER_LEFT, clientLeft, headerFirst, headerSecond);
            RenderTickListener.appendDiff(event.getRight(), ClientDebuggables.SERVER_RIGHT, clientRight, headerFirst, headerSecond);
            debuggable.getClientDebugInfo(event.getLeft(), event.getRight(), mc.field_71476_x.field_178784_b);
        }
    }

    private static void appendDiff(List<String> dest, List<String> first, List<String> second, String headerFirst, String headerSecond) {
        dest.add("");
        dest.add(headerFirst);
        dest.addAll(first);
        dest.add("");
        dest.add(headerSecond);
        if (first.size() != second.size()) {
            dest.addAll(second);
        } else {
            for (int l = 0; l < first.size(); ++l) {
                String diffLine;
                String shownLine = first.get(l);
                if (shownLine.equals(diffLine = second.get(l))) {
                    dest.add(diffLine);
                    continue;
                }
                if (diffLine.startsWith(" ")) {
                    dest.add(DIFF_START + diffLine.substring(1));
                    continue;
                }
                dest.add(DIFF_START + diffLine);
            }
        }
    }

    @SubscribeEvent
    public static void renderLast(RenderWorldLastEvent event) {
        float partialTicks = event.getPartialTicks();
        RenderTickListener.renderHeldItemInWorld(partialTicks);
    }

    private static void renderHeldItemInWorld(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack mainHand = StackUtil.asNonNull(player.func_184614_ca());
        ItemStack offHand = StackUtil.asNonNull(player.func_184592_cb());
        WorldClient world = mc.field_71441_e;
        mc.field_71424_I.func_76320_a("bc");
        mc.field_71424_I.func_76320_a("renderWorld");
        DetachedRenderer.fromWorldOriginPre((EntityPlayer)player, partialTicks);
        Item mainHandItem = mainHand.func_77973_b();
        Item offHandItem = offHand.func_77973_b();
        if (mainHandItem == BCCoreItems.mapLocation) {
            RenderTickListener.renderMapLocation(mainHand);
        } else if (mainHandItem == BCCoreItems.markerConnector || offHandItem == BCCoreItems.markerConnector) {
            RenderTickListener.renderMarkerConnector(world, (EntityPlayer)player);
        }
        DetachedRenderer.fromWorldOriginPost();
        mc.field_71424_I.func_76319_b();
        mc.field_71424_I.func_76319_b();
    }

    private static void renderMapLocation(@Nonnull ItemStack stack) {
        IMapLocation.MapLocationType type = IMapLocation.MapLocationType.getFromStack(stack);
        if (type == IMapLocation.MapLocationType.SPOT) {
            EnumFacing face = ItemMapLocation.getPointFace(stack);
            IBox box = ItemMapLocation.getPointBox(stack);
            if (box != null) {
                Vec3d[][] vectors = MAP_LOCATION_POINT[face.ordinal()];
                GL11.glTranslated((double)box.min().func_177958_n(), (double)box.min().func_177956_o(), (double)box.min().func_177952_p());
                for (Vec3d[] vec : vectors) {
                    LaserData_BC8 laser = new LaserData_BC8(BuildCraftLaserManager.STRIPES_WRITE, vec[0], vec[1], 0.0625);
                    LaserRenderer_BC8.renderLaserStatic(laser);
                }
            }
        } else if (type == IMapLocation.MapLocationType.AREA) {
            IBox box = ItemMapLocation.getAreaBox(stack);
            LAST_RENDERED_MAP_LOC.reset();
            LAST_RENDERED_MAP_LOC.initialize(box);
            LaserBoxRenderer.renderLaserBoxStatic(LAST_RENDERED_MAP_LOC, BuildCraftLaserManager.STRIPES_WRITE, true);
        } else if (type == IMapLocation.MapLocationType.PATH) {
            List<BlockPos> path = BCCoreItems.mapLocation.getPath(stack);
            if (path != null && path.size() > 1) {
                BlockPos last = null;
                for (BlockPos p : path) {
                    if (last != null) continue;
                    last = p;
                }
            }
        } else if (type == IMapLocation.MapLocationType.ZONE) {
            // empty if block
        }
    }

    private static void renderMarkerConnector(WorldClient world, EntityPlayer player) {
        Profiler profiler = Minecraft.func_71410_x().field_71424_I;
        profiler.func_76320_a("marker");
        for (MarkerCache<?> cache : MarkerCache.CACHES) {
            profiler.func_76320_a(cache.name);
            RenderTickListener.renderMarkerCache(player, cache.getSubCache((World)world));
            profiler.func_76319_b();
        }
        profiler.func_76319_b();
    }

    private static void renderMarkerCache(EntityPlayer player, MarkerSubCache<?> cache) {
        Profiler profiler = Minecraft.func_71410_x().field_71424_I;
        profiler.func_76320_a("compute");
        HashSet<LaserData_BC8> toRender = new HashSet<LaserData_BC8>();
        for (BlockPos a : cache.getAllMarkers()) {
            for (BlockPos b : cache.getValidConnections(a)) {
                if (a.func_177986_g() > b.func_177986_g()) continue;
                Vec3d start = VecUtil.convertCenter((Vec3i)a);
                Vec3d end = VecUtil.convertCenter((Vec3i)b);
                Vec3d startToEnd = end.func_178788_d(start).func_72432_b();
                Vec3d endToStart = start.func_178788_d(end).func_72432_b();
                start = start.func_178787_e(VecUtil.scale(startToEnd, 0.125));
                end = end.func_178787_e(VecUtil.scale(endToStart, 0.125));
                LaserData_BC8.LaserType laserType = cache.getPossibleLaserType();
                if (laserType == null || RenderTickListener.isLookingAt(a, b, player)) {
                    laserType = BuildCraftLaserManager.MARKER_DEFAULT_POSSIBLE;
                }
                LaserData_BC8 data = new LaserData_BC8(laserType, start, end, 0.0625);
                toRender.add(data);
            }
        }
        profiler.func_76318_c("render");
        for (LaserData_BC8 laser : toRender) {
            LaserRenderer_BC8.renderLaserStatic(laser);
        }
        profiler.func_76319_b();
    }

    private static boolean isLookingAt(BlockPos from, BlockPos to, EntityPlayer player) {
        return ItemMarkerConnector.doesInteract(from, to, player);
    }

    static {
        LAST_RENDERED_MAP_LOC = new Box();
        double[][][] upFace = new double[][][]{new double[][]{{0.5, 0.9, 0.5}, {0.5, 1.6, 0.5}}, new double[][]{{0.5, 0.9, 0.5}, {0.8, 1.2, 0.5}}, new double[][]{{0.5, 0.9, 0.5}, {0.2, 1.2, 0.5}}, new double[][]{{0.5, 0.9, 0.5}, {0.5, 1.2, 0.8}}, new double[][]{{0.5, 0.9, 0.5}, {0.5, 1.2, 0.2}}};
        for (EnumFacing face : EnumFacing.field_82609_l) {
            Matrix4f matrix = MatrixUtil.rotateTowardsFace(EnumFacing.UP, face);
            Vec3d[][] arr = new Vec3d[5][2];
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 2; ++j) {
                    Vec3d to;
                    double[] from = upFace[i][j];
                    Point3f point = new Point3f(new Point3d(from));
                    matrix.transform(point);
                    arr[i][j] = to = new Vec3d((double)point.x, (double)point.y, (double)point.z);
                }
            }
            RenderTickListener.MAP_LOCATION_POINT[face.ordinal()] = arr;
        }
        DIFF_START = TextFormatting.RED + "" + TextFormatting.BOLD + "!" + TextFormatting.RESET;
        DIFF_HEADER_FORMATTING = TextFormatting.AQUA + "" + TextFormatting.BOLD;
    }
}

