/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.client.gui;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTextureResource
extends ResourceLocation {
    @Nonnegative
    public final int defaultWidth;
    @Nonnegative
    public final int defaultHeight;

    public GuiTextureResource(@Nonnull String location, @Nonnegative int defaultWidth, @Nonnegative int defaultHeight) {
        super("ironbackpacks", "textures/gui/" + location + ".png");
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Preconditions.checkArgument((defaultWidth >= 0 ? 1 : 0) != 0, (Object)"defaultWidth cannot be negative");
        Preconditions.checkArgument((defaultHeight >= 0 ? 1 : 0) != 0, (Object)"defaultHeight cannot be negative");
        this.defaultWidth = defaultWidth;
        this.defaultHeight = defaultHeight;
    }

    public void bind() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a((ResourceLocation)this);
    }

    public void drawQuad(int x, int y, int u, int v, int w, int h, float zLevel) {
        float scaleX = 1.0f / (float)this.defaultWidth;
        float scaleY = 1.0f / (float)this.defaultHeight;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tess.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)(x + 0), (double)(y + h), (double)zLevel).func_187315_a((double)((float)(u + 0) * scaleX), (double)((float)(v + h) * scaleY)).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + w), (double)(y + h), (double)zLevel).func_187315_a((double)((float)(u + w) * scaleX), (double)((float)(v + h) * scaleY)).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + w), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(u + w) * scaleX), (double)((float)(v + 0) * scaleY)).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(u + 0) * scaleX), (double)((float)(v + 0) * scaleY)).func_181675_d();
        tess.func_78381_a();
    }

    public void drawQuad(int x, int y, int u, int v, int w, int h) {
        this.drawQuad(x, y, u, v, w, h, 0.0f);
    }
}

