/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.worldgen;

import com.google.common.base.Objects;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeresources.api.conditionals.Conditional;
import jeresources.api.drop.LootDrop;
import jeresources.config.Settings;
import jeresources.entry.WorldGenEntry;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

public class WorldGenWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    protected static final int X_OFFSET = 29;
    protected static final int Y_OFFSET = 52;
    protected static final int X_AXIS_SIZE = 128;
    protected static final int Y_AXIS_SIZE = 40;
    private final WorldGenEntry worldGenEntry;

    public WorldGenWrapper(WorldGenEntry worldGenEntry) {
        this.worldGenEntry = worldGenEntry;
    }

    public int getLineColor() {
        return this.worldGenEntry.getColour();
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.worldGenEntry.getBlock());
        ingredients.setOutputs(VanillaTypes.ITEM, this.worldGenEntry.getBlockAndDrops());
    }

    public ItemStack getBlock() {
        return this.worldGenEntry.getBlock();
    }

    public List<ItemStack> getDrops() {
        return this.worldGenEntry.getDrops();
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        float[] array = this.worldGenEntry.getChances();
        double max = 0.0;
        float[] fArray = array;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double d = fArray[i];
            if (!(d > max)) continue;
            max = d;
        }
        double xPrev = 29.0;
        double yPrev = 52.0;
        double space = 128.0 / ((double)(array.length - 1) * 1.0);
        for (int i = 0; i < array.length; ++i) {
            double value = array[i];
            double y = 52.0 - value / max * 40.0;
            if (i > 0) {
                double x = xPrev + space;
                RenderHelper.drawLine(xPrev, yPrev, x, y, this.getLineColor());
                xPrev = x;
            }
            yPrev = y;
        }
        int xPercents = 27;
        int yPercents = 45;
        String minPercent = "0%";
        int minPercentWidth = Font.small.getStringWidth("0%");
        Font.small.print("0%", 27 - minPercentWidth, 45);
        String maxPercent = String.format("%.2f", max * 100.0) + "%";
        int maxPercentWidth = Font.small.getStringWidth(maxPercent);
        Font.small.print(maxPercent, 27 - maxPercentWidth, 5);
        int yLabels = 52;
        int xLabels = 29;
        int minLabel = this.worldGenEntry.getMinY();
        int minLabelWidth = Font.small.getStringWidth(String.valueOf(minLabel));
        int minLabelOffset = 29 - minLabelWidth / 2;
        Font.small.print(minLabel, minLabelOffset, 52);
        int maxLabel = this.worldGenEntry.getMaxY();
        int maxLabelWidth = Font.small.getStringWidth(String.valueOf(maxLabel));
        int maxLabelOffset = 157 - maxLabelWidth / 2;
        Font.small.print(maxLabel, maxLabelOffset, 52);
        int midLabel = (maxLabel + minLabel) / 2;
        int midLabelWidth = Font.small.getStringWidth(String.valueOf(midLabel));
        int midLabelOffset = 93 - midLabelWidth / 2;
        Font.small.print(midLabel, midLabelOffset, 52);
        Font.small.print(TranslationHelper.translateToLocal("jer.worldgen.drops"), 5, 58);
        String dimension = TranslationHelper.tryDimensionTranslate(this.worldGenEntry.getDimension());
        int x = (recipeWidth - Font.normal.getStringWidth(dimension)) / 2;
        Font.normal.print(dimension, x, 0);
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        List<String> tooltip = new LinkedList<String>();
        if (this.onGraph(mouseX, mouseY)) {
            tooltip = this.getLineTooltip(mouseX, tooltip);
        }
        return tooltip;
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        tooltip.addAll(this.getItemStackTooltip(slotIndex, ingredient));
    }

    private List<String> getItemStackTooltip(int slot, ItemStack itemStack) {
        LinkedList<String> tooltip = new LinkedList<String>();
        if (itemStack != null && slot == 0) {
            List<String> biomes;
            if (this.worldGenEntry.isSilkTouchNeeded()) {
                tooltip.add(Conditional.silkTouch.toString());
            }
            if ((biomes = this.worldGenEntry.getBiomeRestrictions()).size() > 0) {
                tooltip.add(TranslationHelper.translateToLocal("jer.worldgen.biomes") + ":");
                tooltip.addAll(biomes);
            }
            if (Settings.showDevData) {
                tooltip.add(TranslationHelper.translateToLocal("jer.worldgen.average") + ":");
                tooltip.add("" + this.worldGenEntry.getAverageBlockCountPerChunk());
            }
        } else {
            tooltip.add(TranslationHelper.translateToLocal("jer.worldgen.average"));
            String previousChanceString = null;
            for (LootDrop dropItem : this.worldGenEntry.getLootDrops(itemStack)) {
                String chanceString = dropItem.chanceString();
                if (Objects.equal((Object)chanceString, previousChanceString)) continue;
                previousChanceString = chanceString;
                String line = "  ";
                line = dropItem.fortuneLevel > 0 ? line + Enchantment.func_180305_b((String)"fortune").func_77316_c(dropItem.fortuneLevel) : line + TranslationHelper.translateToLocal("jer.worldgen.base");
                line = line + ": " + chanceString;
                tooltip.add(line);
            }
        }
        return tooltip;
    }

    private List<String> getLineTooltip(int mouseX, List<String> tooltip) {
        double exactMouseX = WorldGenWrapper.getExactMouseX(mouseX);
        float[] chances = this.worldGenEntry.getChances();
        double space = 128.0 / ((double)chances.length * 1.0);
        int index = (int)((exactMouseX - 29.0 + 1.0) / space);
        int yValue = index + this.worldGenEntry.getMinY();
        if (index >= 0 && index < chances.length) {
            float chance = chances[index] * 100.0f;
            String percent = chance > 0.01f || chance == 0.0f ? String.format(" (%.2f%%)", Float.valueOf(chance)) : " <0.01%";
            tooltip.add("Y: " + yValue + percent);
        }
        return tooltip;
    }

    private static double getExactMouseX(int mouseX) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        int scaledWidth = scaledresolution.func_78326_a();
        double mouseXExact = (double)(Mouse.getX() * scaledWidth) / (double)mc.field_71443_c;
        double mouseXFraction = mouseXExact - Math.floor(mouseXExact);
        return (double)mouseX + mouseXFraction;
    }

    private boolean onGraph(int mouseX, int mouseY) {
        return mouseX >= 28 && mouseX < 157 && mouseY >= 11 && mouseY < 52;
    }
}

