/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei;

import javax.annotation.Nonnull;
import jeresources.JEResources;
import jeresources.config.Settings;
import jeresources.entry.DungeonEntry;
import jeresources.entry.MobEntry;
import jeresources.entry.PlantEntry;
import jeresources.entry.VillagerEntry;
import jeresources.entry.WorldGenEntry;
import jeresources.jei.dungeon.DungeonCategory;
import jeresources.jei.dungeon.DungeonWrapper;
import jeresources.jei.enchantment.EnchantmentCategory;
import jeresources.jei.enchantment.EnchantmentMaker;
import jeresources.jei.enchantment.EnchantmentWrapper;
import jeresources.jei.mob.MobCategory;
import jeresources.jei.mob.MobWrapper;
import jeresources.jei.plant.PlantCategory;
import jeresources.jei.plant.PlantWrapper;
import jeresources.jei.villager.VillagerCategory;
import jeresources.jei.villager.VillagerWrapper;
import jeresources.jei.worldgen.WorldGenCategory;
import jeresources.jei.worldgen.WorldGenWrapper;
import jeresources.registry.DungeonRegistry;
import jeresources.registry.MobRegistry;
import jeresources.registry.PlantRegistry;
import jeresources.registry.VillagerRegistry;
import jeresources.registry.WorldGenRegistry;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;

@JEIPlugin
public class JEIConfig
implements IModPlugin {
    public static final String MOB = "jeresources.mob";
    public static final String DUNGEON = "jeresources.dungeon";
    public static final String WORLD_GEN = "jeresources.worldgen";
    public static final String PLANT = "jeresources.plant";
    public static final String ENCHANTMENT = "jeresources.enchantment";
    public static final String VILLAGER = "jeresources.villager";
    public static final String[] CATEGORIES = new String[]{"jeresources.mob", "jeresources.dungeon", "jeresources.worldgen", "jeresources.plant", "jeresources.enchantment", "jeresources.villager"};
    private static IJeiHelpers jeiHelpers;
    private static IJeiRuntime jeiRuntime;

    public void register(@Nonnull IModRegistry registry) {
        registry.handleRecipes(WorldGenEntry.class, WorldGenWrapper::new, WORLD_GEN);
        registry.handleRecipes(PlantEntry.class, PlantWrapper::new, PLANT);
        registry.handleRecipes(MobEntry.class, MobWrapper::new, MOB);
        registry.handleRecipes(DungeonEntry.class, DungeonWrapper::new, DUNGEON);
        registry.handleRecipes(VillagerEntry.class, VillagerWrapper::new, VILLAGER);
        registry.handleRecipes(EnchantmentWrapper.class, recipe -> recipe, ENCHANTMENT);
        JEResources.PROXY.initCompatibility();
        registry.addRecipes(WorldGenRegistry.getInstance().getWorldGen(), WORLD_GEN);
        registry.addRecipes(PlantRegistry.getInstance().getAllPlants(), PLANT);
        registry.addRecipes(MobRegistry.getInstance().getMobs(), MOB);
        registry.addRecipes(DungeonRegistry.getInstance().getDungeons(), DUNGEON);
        registry.addRecipes(VillagerRegistry.getInstance().getVillagers(), VILLAGER);
        registry.addRecipes(EnchantmentMaker.createRecipes(registry.getIngredientRegistry().getAllIngredients(VanillaTypes.ITEM)), ENCHANTMENT);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIConfig.jeiRuntime = jeiRuntime;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new PlantCategory(), new WorldGenCategory(), new MobCategory(), new EnchantmentCategory(), new DungeonCategory(), new VillagerCategory()});
        JEIConfig.hideCategories(Settings.hiddenCategories);
    }

    public static void resetCategories() {
        for (String category : CATEGORIES) {
            jeiRuntime.getRecipeRegistry().unhideRecipeCategory(category);
        }
    }

    public static void hideCategories(String[] categories) {
        for (String category : categories) {
            jeiRuntime.getRecipeRegistry().hideRecipeCategory("jeresources." + category);
        }
    }

    public static IJeiHelpers getJeiHelpers() {
        return jeiHelpers;
    }
}

