/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.init.ModItems;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.part.TransceiverPart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class TransmitterPart
extends TransceiverPart {
    public static Cuboid6[] extensionBB = new Cuboid6[24];

    @Override
    public ItemStack getItem() {
        return new ItemStack(ModItems.itemWireless, 1, 0);
    }

    @Override
    public void onNeighborChanged() {
        if (this.dropIfCantStay()) {
            return;
        }
        int gettingPowered = this.getPoweringLevel();
        if (!this.active() && gettingPowered > 0) {
            this.trySetState(true);
        } else if (this.active() && gettingPowered == 0) {
            this.trySetState(false);
        }
    }

    private void trySetState(boolean on) {
        this.setActive(on);
        if (!this.disabled() || !on) {
            this.changeSpinState(on);
            RedstoneEther.server().setTransmitter(this.world(), this.pos(), this.currentfreq, this.active());
        }
        this.updateChange();
    }

    private void changeSpinState(boolean on) {
        if (on && this.spinoffset < 0) {
            int time;
            this.spinoffset = time = (int)((this.world().func_82737_E() + (long)this.spinoffset) % 100000L);
        } else if (!on && this.spinoffset >= 0) {
            int time = (int)((this.world().func_82737_E() - (long)this.spinoffset) % 100000L);
            this.spinoffset = -time;
        }
    }

    @Override
    public void jamTile() {
        super.jamTile();
        this.updateChange();
    }

    @Override
    public void unjamTile() {
        super.unjamTile();
        this.addToEther();
        this.onNeighborChanged();
    }

    @Override
    public Vector3 getFocalPoint() {
        return new Vector3(0.3125, 0.24, 0.0).apply(this.rotationT());
    }

    @Override
    public Vector3 getPearlPos() {
        return new Vector3(0.5, 0.74 + this.getFloating() * 0.04, 0.3125);
    }

    @Override
    public double getPearlSpin() {
        if (this.spinoffset < 0) {
            return RedstoneEther.getRotation(-this.spinoffset, this.currentfreq);
        }
        return RedstoneEther.getRotation(ClientUtils.getRenderTime() - (double)this.spinoffset, this.currentfreq);
    }

    @Override
    public float getPearlLight() {
        float light = this.world().func_175724_o(this.pos());
        light = (this.deadmap & 1) == 1 || this.deadmap == 0 && (this.disabled() || !this.active() || this.currentfreq == 0) ? (light + 1.0f) * 0.25f : (light + 1.0f) * 0.5f;
        return light;
    }

    @Override
    public void setFreq(int newfreq) {
        super.setFreq(newfreq);
        this.changeSpinState(this.active());
    }

    private void resetRotation() {
        this.spinoffset = this.active() ? 0 : -1;
    }

    @Override
    public void addToEther() {
        this.resetRotation();
        this.updateChange();
        RedstoneEther.server().setTransmitter(this.world(), this.pos(), this.currentfreq, this.active() && !this.disabled());
    }

    @Override
    public void removeFromEther() {
        RedstoneEther.server().remTransmitter(this.world(), this.pos(), this.currentfreq);
    }

    @Override
    public String getGuiName() {
        return I18n.func_74838_a((String)"item.wrcbe:wireless_part|0.name");
    }

    public ResourceLocation getType() {
        return new ResourceLocation("wrcbe:transmitter");
    }

    @Override
    public void read(MCDataInput packet) {
        super.read(packet);
        this.changeSpinState(this.active());
    }

    @Override
    public Cuboid6 getExtensionBB() {
        return extensionBB[this.shape()];
    }

    @Override
    public int modelId() {
        return 0;
    }

    static {
        Cuboid6 base = new Cuboid6(0.4375, 0.125, 0.25, 0.5625, 0.875, 0.375);
        for (int s = 0; s < 6; ++s) {
            for (int r = 0; r < 4; ++r) {
                TransmitterPart.extensionBB[s << 2 | r] = base.copy().apply(Rotation.sideOrientation((int)s, (int)r).at(Vector3.center));
            }
        }
    }
}

