/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.client.texture;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.texture.TextureDataHolder;
import codechicken.lib.texture.TextureSpecial;
import codechicken.lib.texture.TextureUtils;
import codechicken.wirelessredstone.manager.RedstoneEther;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public class RemoteTexManager
implements TextureUtils.IIconRegister {
    private static Colour[] texGrad;
    private static Colour[] texOff;
    private static Colour[] texOn;
    private static int[] imageData;
    private static TextureSpecial[] icons;

    public void registerIcons(TextureMap textureMap) {
        int i;
        for (i = 0; i < icons.length; ++i) {
            RemoteTexManager.icons[i] = TextureUtils.getTextureSpecial((TextureMap)textureMap, (String)("wrcbe:remote_" + i));
        }
        texOn = TextureUtils.loadTextureColours((ResourceLocation)new ResourceLocation("wrcbe", "textures/items/remote_on.png"));
        texOff = TextureUtils.loadTextureColours((ResourceLocation)new ResourceLocation("wrcbe", "textures/items/remote_off.png"));
        texGrad = TextureUtils.loadTextureColours((ResourceLocation)new ResourceLocation("wrcbe", "textures/items/remote_grad.png"));
        for (i = 0; i < 14; ++i) {
            RemoteTexManager.processTexture(RedstoneEther.colours[i], false, RemoteTexManager.getIconIndex(i, false));
            RemoteTexManager.processTexture(RedstoneEther.colours[i], true, RemoteTexManager.getIconIndex(i, true));
        }
        RemoteTexManager.processTexture(-1, false, RemoteTexManager.getIconIndex(-1, false));
        RemoteTexManager.processTexture(-1, true, RemoteTexManager.getIconIndex(-1, true));
    }

    private static void processTexture(int colour, boolean on, int i) {
        RemoteTexManager.mergeTexturesWithColour((Colour)new ColourARGB(colour), on);
        icons[i].addTexture(new TextureDataHolder(imageData, 16).copyData());
    }

    public static TextureAtlasSprite getIcon(int colourid, boolean on) {
        return icons[RemoteTexManager.getIconIndex(colourid, on)];
    }

    public static int getIconIndex(int colourid, boolean on) {
        return colourid + 1 + (on ? 15 : 0);
    }

    private static void mergeTexturesWithColour(Colour texcolour, boolean on) {
        for (int i = 0; i < 256; ++i) {
            Colour colour = RemoteTexManager.texGrad[i].a == 0 ? (on ? texOn[i] : texOff[i]) : texGrad[i].copy().multiply(texcolour);
            RemoteTexManager.imageData[i] = colour.argb();
        }
    }

    static {
        imageData = new int[256];
        icons = new TextureSpecial[30];
    }
}

