/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator.tree;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GeneratorTaigaTree
extends GeneratorTreeBase {
    private int trunkWidth;

    public GeneratorTaigaTree(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight, int trunkWidth, GeneratorUtils.ScatterYMethod scatterYMethod) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, trunkFruit, altLeaves, minHeight, maxHeight, scatterYMethod);
        this.trunkWidth = trunkWidth;
    }

    public boolean checkSpace(World world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int trunkWidth = this.trunkWidth * (height - y) / height + 1;
            int trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            int start = y <= baseHeight ? trunkStart : trunkStart - 1;
            int end = y <= baseHeight ? trunkEnd : trunkEnd + 1;
            for (int x = start; x <= end; ++x) {
                for (int z = start; z <= end; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(World world, Random rand, BlockPos pos, int leavesRadius, int trunkStart, int trunkEnd) {
        int start = trunkStart - leavesRadius;
        int end = trunkEnd + leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                int distFromTrunk;
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || (distFromTrunk = (x < 0 ? trunkStart - x : x - trunkEnd) + (z < 0 ? trunkStart - z : z - trunkEnd)) >= 4 && (distFromTrunk != 4 || rand.nextInt(2) != 0)) continue;
                this.setLeaves(world, pos.func_177982_a(x, 0, z));
            }
        }
    }

    public void generateBranch(World world, Random rand, BlockPos pos, EnumFacing direction, int length) {
        EnumFacing.Axis axis = direction.func_176740_k();
        EnumFacing sideways = direction.func_176746_e();
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.func_177967_a(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.nextInt(2) != 0) continue;
                this.setLeaves(world, pos1.func_177967_a(sideways, j));
            }
            if (length - i <= 2) continue;
            this.setLeaves(world, pos1.func_177984_a());
            this.setLeaves(world, pos1.func_177984_a().func_177967_a(sideways, -1));
            this.setLeaves(world, pos1.func_177984_a().func_177967_a(sideways, 1));
            this.setLog(world, pos1, axis);
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos startPos) {
        int trunkEnd;
        int trunkStart;
        int trunkWidth;
        int baseHeight;
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_177230_c().isLeaves(world.func_180495_p(startPos), (IBlockAccess)world, startPos)) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtils.nextIntBetween(random, this.minHeight, this.maxHeight);
        int leavesHeight = height - (baseHeight = GeneratorUtils.nextIntBetween(random, height / 5, height / 3));
        if (leavesHeight < 3) {
            return false;
        }
        if (!this.checkSpace(world, startPos.func_177984_a(), baseHeight, height)) {
            return false;
        }
        BlockPos pos = startPos.func_177981_b(height);
        this.setLeaves(world, pos);
        pos.func_177977_b();
        for (int i = 0; i < leavesHeight; ++i) {
            trunkWidth = this.trunkWidth * i / height + 1;
            trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            int radius = Math.min(Math.min((i + 2) / 3, 3 + (leavesHeight - i)), 6);
            if (radius == 0) {
                this.setLeaves(world, pos);
            } else if (radius < 4) {
                if (i % 2 == 0) {
                    this.generateLeafLayer(world, random, pos, radius, trunkStart, trunkEnd);
                } else {
                    this.generateLeafLayer(world, random, pos, radius / 2, trunkStart, trunkEnd);
                }
            } else if (i % 2 == 0) {
                this.generateBranch(world, random, pos.func_177982_a(trunkStart, 0, trunkStart), EnumFacing.NORTH, radius);
                this.generateBranch(world, random, pos.func_177982_a(trunkEnd, 0, trunkStart), EnumFacing.EAST, radius);
                this.generateBranch(world, random, pos.func_177982_a(trunkEnd, 0, trunkEnd), EnumFacing.SOUTH, radius);
                this.generateBranch(world, random, pos.func_177982_a(trunkStart, 0, trunkEnd), EnumFacing.WEST, radius);
            }
            pos = pos.func_177977_b();
        }
        for (int y = 0; y < height - 1; ++y) {
            trunkWidth = this.trunkWidth * (height - y) / height + 1;
            trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            if (this.trunkWidth <= 1) {
                trunkStart = 0;
                trunkEnd = 0;
            }
            for (int x = trunkStart; x <= trunkEnd; ++x) {
                for (int z = trunkStart; z <= trunkEnd; ++z) {
                    this.setLog(world, startPos.func_177982_a(x, y, z));
                }
            }
        }
        return true;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.minHeight = conf.getInt("minHeight", this.minHeight);
        this.maxHeight = conf.getInt("minHeight", this.maxHeight);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
        this.vine = conf.getBlockState("vinesState", this.vine);
        this.trunkWidth = conf.getInt("trunkWidth", this.trunkWidth);
    }

    public static class Builder
    extends GeneratorTreeBase.InnerBuilder<Builder, GeneratorTaigaTree>
    implements IGenerator.IGeneratorBuilder<GeneratorTaigaTree> {
        protected int trunkWidth;

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.minHeight = 6;
            this.maxHeight = 12;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.airOrLeaves;
            this.log = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE);
            this.leaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE);
            this.vine = Blocks.field_150395_bd.func_176223_P();
            this.hanging = null;
            this.trunkFruit = null;
            this.altLeaves = null;
            this.trunkWidth = 1;
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
        }

        @Override
        public GeneratorTaigaTree create() {
            return new GeneratorTaigaTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.trunkFruit, this.altLeaves, this.minHeight, this.maxHeight, this.trunkWidth, this.scatterYMethod);
        }
    }
}

