/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util.biome;

import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.WorldTypeBOP;
import biomesoplenty.core.BiomesOPlenty;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeUtils {
    private static final Function<ResourceLocation, Pair<ResourceLocation, Biome>> MAPPING_FOR_LOCATION = new Function<ResourceLocation, Pair<ResourceLocation, Biome>>(){

        @Nullable
        public Pair<ResourceLocation, Biome> apply(@Nullable ResourceLocation input) {
            return Pair.of((Object)input, (Object)Biome.field_185377_q.func_82594_a((Object)input));
        }
    };

    public static int getBiomeSize(World world) {
        String generatorSettingsJson = world.func_72912_H().func_82571_y();
        if (world.func_175624_G() instanceof WorldTypeBOP) {
            return new BOPWorldSettings((String)generatorSettingsJson).biomeSize.getValue();
        }
        return ChunkGeneratorSettings.Factory.func_177865_a((String)generatorSettingsJson).func_177864_b().field_177780_G;
    }

    @Deprecated
    public static ResourceLocation getLocForBiome(Biome biome) {
        return (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome);
    }

    public static Biome getBiomeForLoc(ResourceLocation location) {
        return (Biome)Biome.field_185377_q.func_82594_a((Object)location);
    }

    public static List<Biome> getRegisteredBiomes() {
        return Lists.newArrayList((Iterator)Biome.field_185377_q.iterator());
    }

    public static BlockPos spiralOutwardsLookingForBiome(World world, Biome biomeToFind, double startX, double startZ) {
        int sampleSpacing = 4 << BiomeUtils.getBiomeSize(world);
        int maxDist = sampleSpacing * 100;
        return BiomeUtils.spiralOutwardsLookingForBiome(world, biomeToFind, startX, startZ, maxDist, sampleSpacing);
    }

    public static List<Biome> filterPresentBiomes(Optional<Biome> ... biomes) {
        return Lists.newArrayList((Iterable)Optional.presentInstances((Iterable)Sets.newHashSet((Object[])biomes)));
    }

    public static BlockPos spiralOutwardsLookingForBiome(World world, Biome biomeToFind, double startX, double startZ, int maxDist, int sampleSpace) {
        if (maxDist <= 0 || sampleSpace <= 0) {
            throw new IllegalArgumentException("maxDist and sampleSpace must be positive");
        }
        BiomeProvider chunkManager = world.func_72959_q();
        double a = (double)sampleSpace / Math.sqrt(Math.PI);
        double b = 2.0 * Math.sqrt(Math.PI);
        double x = 0.0;
        double z = 0.0;
        double dist = 0.0;
        int n = 0;
        String biomeName = FMLCommonHandler.instance().getSide() == Side.CLIENT ? biomeToFind.func_185359_l() : "biome";
        n = 0;
        while (dist < (double)maxDist) {
            double rootN = Math.sqrt(n);
            dist = a * rootN;
            x = startX + dist * Math.sin(b * rootN);
            Biome[] biomesAtSample = chunkManager.func_76931_a(null, (int)x, (int)(z = startZ + dist * Math.cos(b * rootN)), 1, 1, false);
            if (biomesAtSample[0] == biomeToFind) {
                BiomesOPlenty.logger.info("Found " + biomeName + " after " + n + " samples, spaced " + sampleSpace + " blocks apart at (" + (int)x + "," + (int)z + ") distance " + (int)dist);
                return new BlockPos((int)x, 0, (int)z);
            }
            ++n;
        }
        BiomesOPlenty.logger.info("Failed to find " + biomeName + " gave up after " + n + " samples, spaced " + sampleSpace + " blocks apart distance " + (int)dist);
        return null;
    }
}

