/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.gui.controls.BeefGuiVerticalProgressBar;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;

public abstract class BeefGuiTextureProgressBar
extends BeefGuiVerticalProgressBar {
    protected double barLeftU = this.getBarLeftU();
    protected double barRightU = this.getBarRightU();
    ResourceLocation barTexture = this.getBarTexture();

    public BeefGuiTextureProgressBar(BeefGuiBase container, int x, int y) {
        super(container, x, y);
    }

    protected double getBarLeftU() {
        return 0.5;
    }

    protected double getBarRightU() {
        return 0.9999;
    }

    protected ResourceLocation getBarTexture() {
        return this.controlResource;
    }

    @Override
    protected double getBackgroundLeftU() {
        return 0.0;
    }

    @Override
    protected double getBackgroundRightU() {
        return 0.499;
    }

    @Override
    protected void drawProgressBar(Tessellator tessellator, TextureManager renderEngine, int barMinX, int barMaxX, int barMinY, int barMaxY, int zLevel) {
        double barHeight = Math.round(this.getProgress() * (float)(this.height - 2)) + 2;
        if ((double)this.getProgress() > 1.0E-5) {
            barHeight = Math.max(this.getBarMinHeight(), barHeight);
        }
        double barMaxV = 1.0;
        double barMinV = 1.0 - Math.min(1.0, Math.max(0.0, barHeight / (double)this.height));
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        renderEngine.func_110577_a(this.getBarTexture());
        vertexBuffer.func_181668_a(7, vertexBuffer.func_178973_g());
        vertexBuffer.func_181662_b((double)this.absoluteX, (double)(this.absoluteY + this.height), (double)zLevel).func_187315_a(this.barLeftU, barMaxV).func_181675_d();
        vertexBuffer.func_181662_b((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height), (double)zLevel).func_187315_a(this.barRightU, barMaxV).func_181675_d();
        vertexBuffer.func_181662_b((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height) - barHeight, (double)zLevel).func_187315_a(this.barRightU, barMinV).func_181675_d();
        vertexBuffer.func_181662_b((double)this.absoluteX, (double)(this.absoluteY + this.height) - barHeight, (double)zLevel).func_187315_a(this.barLeftU, barMinV).func_181675_d();
        tessellator.func_78381_a();
    }

    protected double getBarMinHeight() {
        return 3.0;
    }
}

