/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.compat.CompatManager;
import erogenousbeef.bigreactors.common.multiblock.computer.ReactorComputerPeripheral;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerPeripheral;
import it.zerono.mods.zerocore.lib.compat.computer.Connector;
import it.zerono.mods.zerocore.lib.compat.computer.ConnectorComputerCraft;
import it.zerono.mods.zerocore.lib.compat.computer.ConnectorOpenComputers;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart", modid="opencomputers")})
public class TileEntityReactorComputerPort
extends TileEntityReactorPart {
    private final Connector _ocConnector;
    private final Connector _ccConnector;

    public TileEntityReactorComputerPort() {
        ReactorComputerPeripheral reactorPeripheral = new ReactorComputerPeripheral(this);
        this._ocConnector = CompatManager.isModLoaded("opencomputers") ? ConnectorOpenComputers.create((String)"br_reactor", (ComputerPeripheral)reactorPeripheral) : null;
        this._ccConnector = CompatManager.isModLoaded("computercraft") ? ConnectorComputerCraft.create((String)"BigReactors-Reactor", (ComputerPeripheral)reactorPeripheral) : null;
    }

    @Optional.Method(modid="opencomputers")
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return null != this._ocConnector && ConnectorOpenComputers.isComputerCapability(capability) || super.hasCapability(capability, facing);
    }

    @Nullable
    @Optional.Method(modid="opencomputers")
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (null != this._ocConnector && ConnectorOpenComputers.isComputerCapability(capability)) {
            return (T)this._ocConnector;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Optional.Method(modid="computercraft")
    public Connector getComputerCraftPeripheral() {
        return this._ccConnector;
    }

    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        if (null != this._ccConnector) {
            this._ccConnector.onAttachedToController();
        }
        if (null != this._ocConnector) {
            this._ocConnector.onAttachedToController();
        }
    }

    public void onDetached(MultiblockControllerBase oldController) {
        super.onDetached(oldController);
        if (null != this._ccConnector) {
            this._ccConnector.onDetachedFromController();
        }
        if (null != this._ocConnector) {
            this._ocConnector.onDetachedFromController();
        }
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (null != this._ccConnector) {
            this._ccConnector.syncDataFrom(data, syncReason);
        }
        if (null != this._ocConnector) {
            this._ocConnector.syncDataFrom(data, syncReason);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (null != this._ccConnector) {
            this._ccConnector.syncDataTo(data, syncReason);
        }
        if (null != this._ocConnector) {
            this._ocConnector.syncDataTo(data, syncReason);
        }
    }
}

