/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.render;

import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.compactmachines3.block.BlockFieldProjector;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.misc.RenderTickCounter;
import org.dave.compactmachines3.tile.TileEntityFieldProjector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TESRFieldProjector
extends TileEntitySpecialRenderer<TileEntityFieldProjector> {
    private static IModel model;
    private static IBakedModel bakedModel;

    public static void prebakeModel() {
        if (bakedModel == null) {
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("compactmachines3", "block/fieldprojectordish"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            bakedModel = model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b("compactmachines3:blocks/fieldprojector"));
        }
    }

    private void renderModel(TileEntityFieldProjector te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179101_C();
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        EnumFacing facing = EnumFacing.NORTH;
        if (te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c() == Blockss.fieldProjector) {
            facing = (EnumFacing)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockFieldProjector.FACING);
        }
        int xyAngle = (facing.func_176736_b() - 1) * -90;
        GlStateManager.func_179114_b((float)xyAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        double zAngle = Math.sin(Math.toDegrees(RenderTickCounter.renderTicks) / 5000.0) * 10.0;
        float yDiskOffset = -0.66f;
        GlStateManager.func_179137_b((double)0.0, (double)(-yDiskOffset), (double)0.0);
        GlStateManager.func_179114_b((float)((float)zAngle), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)yDiskOffset, (double)0.0);
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        World world = te.func_145831_w();
        GlStateManager.func_179109_b((float)(-te.func_174877_v().func_177958_n()), (float)(-te.func_174877_v().func_177956_o()), (float)(-te.func_174877_v().func_177952_p()));
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, bakedModel, world.func_180495_p(te.func_174877_v()), te.func_174877_v(), Tessellator.func_178181_a().func_178180_c(), false);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
        GlStateManager.func_179099_b();
    }

    private void renderField(TileEntityFieldProjector te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        BlockPos centerOfField = te.func_174877_v().func_177967_a(te.getDirection(), te.getActiveMagnitude() * 2);
        AxisAlignedBB cube = new AxisAlignedBB(centerOfField).func_186662_g((double)te.getActiveMagnitude() - 0.98);
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        double extraLength = 0.0;
        cube = cube.func_72317_d((double)(-te.func_174877_v().func_177958_n()), (double)(-te.func_174877_v().func_177956_o()), (double)(-te.func_174877_v().func_177952_p()));
        if (te.getActiveRecipe() != null && te.getCraftingProgress() > 0) {
            double progress = 1.0 - (double)te.getCraftingProgress() / (double)te.getActiveRecipe().getTicks();
            double scale = 1.0 - progress * (1.0 - (Math.sin(Math.toDegrees(RenderTickCounter.renderTicks) / 4000.0) + 1.0) * (double)0.1f);
            scale = Math.min(scale, 0.9);
            cube = cube.func_186664_h(scale * (double)te.getActiveMagnitude());
            extraLength = scale * (double)te.getActiveMagnitude() * 2.0;
        }
        this.renderOutline(cube, te);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179132_a((boolean)false);
        this.renderFaces(cube, extraLength);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        RenderHelper.func_74519_b();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        GlStateManager.func_179098_w();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    private void renderFaces(AxisAlignedBB cube, double extraLength) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int color = 16738816;
        float cR = (float)(color >> 16 & 0xFF) / 255.0f;
        float cG = (float)(color >> 8 & 0xFF) / 255.0f;
        float cB = (float)(color & 0xFF) / 255.0f;
        float cA = 0.15f;
        double x1 = cube.field_72340_a;
        double x2 = cube.field_72336_d;
        double y1 = cube.field_72338_b;
        double y2 = cube.field_72337_e;
        double z1 = cube.field_72339_c;
        double z2 = cube.field_72334_f;
        double radius = (cube.field_72337_e - cube.field_72338_b) / 2.0;
        double y4 = cube.field_72337_e - radius + 0.3;
        buffer.func_181662_b(x1, y1, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y2, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y2, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y1, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y1, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y1, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y2, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y2, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y1, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y1, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y1, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y1, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y2, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y2, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y2, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y2, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y1, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y1, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y2, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y2, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y1, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y2, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y2, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y1, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        double zAngle = (Math.sin(Math.toDegrees(RenderTickCounter.renderTicks) / -5000.0) + 1.0) / 2.0 * (cube.field_72337_e - cube.field_72338_b);
        double y3 = y1 + zAngle;
        float cA2 = 0.105f;
        GlStateManager.func_179129_p();
        GL11.glDisable((int)2884);
        buffer.func_181662_b(x1, y3, z1).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x2, y3, z1).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x2 - (radius - (double)0.2f), y4, z1 - (radius + (double)0.8f + extraLength)).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x1 + (radius - (double)0.2f), y4, z1 - (radius + (double)0.8f + extraLength)).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x2, y3, z1).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x2, y3, z2).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x2 + (radius + (double)0.8f + extraLength), y4, z2 - (radius - (double)0.2f)).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x2 + (radius + (double)0.8f + extraLength), y4, z1 + (radius - (double)0.2f)).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x1, y3, z2).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x2, y3, z2).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x2 - (radius - (double)0.2f), y4, z2 + (radius + (double)0.8f + extraLength)).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x1 + (radius - (double)0.2f), y4, z2 + (radius + (double)0.8f + extraLength)).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x1, y3, z1).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x1, y3, z2).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x1 - (radius + (double)0.8f + extraLength), y4, z2 - (radius - (double)0.2f)).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        buffer.func_181662_b(x1 - (radius + (double)0.8f + extraLength), y4, z1 + (radius - (double)0.2f)).func_181666_a(cR, cG, cB, cA2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
    }

    private void renderOutline(AxisAlignedBB cube, TileEntityFieldProjector te) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        int color = 16738816;
        float cR = (float)(color >> 16 & 0xFF) / 255.0f;
        float cG = (float)(color >> 8 & 0xFF) / 255.0f;
        float cB = (float)(color & 0xFF) / 255.0f;
        float cA = 0.5f;
        double x1 = cube.field_72340_a;
        double x2 = cube.field_72336_d;
        double y1 = cube.field_72338_b;
        double y2 = cube.field_72337_e;
        double z1 = cube.field_72339_c;
        double z2 = cube.field_72334_f;
        double zAngle = (Math.sin(Math.toDegrees(RenderTickCounter.renderTicks) / -5000.0) + 1.0) / 2.0 * (y2 - y1);
        double y3 = y1 + zAngle;
        buffer.func_181662_b(x1, y3, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y3, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y3, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y3, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y3, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y3, z1).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x1, y3, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        buffer.func_181662_b(x2, y3, z2).func_181666_a(cR, cG, cB, cA).func_181675_d();
        tessellator.func_78381_a();
    }

    public void render(TileEntityFieldProjector te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.renderModel(te, x, y, z, partialTicks, destroyStage, alpha);
        if (te.isMaster() && te.shouldRenderField()) {
            this.renderField(te, x, y, z, partialTicks, destroyStage, alpha);
        }
    }

    public boolean isGlobalRenderer(TileEntityFieldProjector te) {
        return true;
    }
}

