/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.dave.compactmachines3.block.BlockMachine;
import org.dave.compactmachines3.block.IMetaBlockName;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.utility.TextFormattingHelper;

public class ItemBlockMachine
extends ItemBlock {
    public ItemBlockMachine(Block block) {
        super(block);
        if (!(block instanceof IMetaBlockName)) {
            throw new IllegalArgumentException(String.format("The given block %s is not an instance of IMetaBlockName!", block.func_149739_a()));
        }
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + ((IMetaBlockName)this.field_150939_a).getSpecialName(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int coords;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("coords") && (coords = stack.func_77978_p().func_74762_e("coords")) > -1) {
            tooltip.add(TextFormattingHelper.colorizeKeyValue(I18n.func_135052_a((String)"tooltip.compactmachines3.machine.coords", (Object[])new Object[0]) + " #" + coords));
        }
        if (GuiScreen.func_146272_n()) {
            int size = ((EnumMachineSize)((Object)Blockss.machine.func_176203_a(stack.func_77952_i()).func_177229_b(BlockMachine.SIZE))).getDimension() - 1;
            String sizeString = size + "x" + size + "x" + size;
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.compactmachines3.machine.hint", (Object[])new Object[]{I18n.func_135052_a((String)(this.func_77667_c(stack) + ".name"), (Object[])new Object[0]), sizeString}));
        } else {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.compactmachines3.hold_shift.hint", (Object[])new Object[0]));
        }
    }
}

