/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.command;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.dave.compactmachines3.block.BlockFieldProjector;
import org.dave.compactmachines3.command.CommandBaseExt;
import org.dave.compactmachines3.miniaturization.MultiblockRecipe;
import org.dave.compactmachines3.miniaturization.MultiblockRecipes;

public class CommandRecipeGenerateInWorld
extends CommandBaseExt {
    public String func_71517_b() {
        return "generate";
    }

    @Override
    public boolean isAllowed(EntityPlayer player, boolean creative, boolean isOp) {
        return isOp;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EnumFacing dir;
        if (!(sender.func_174793_f() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender.func_174793_f();
        if (args.length != 1) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.recipe.generate.exception.missing_machine_recipe", new Object[0]));
            return;
        }
        MultiblockRecipe recipe = MultiblockRecipes.getRecipeByName(args[0]);
        if (recipe == null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.recipe.generate.exception.unknown_recipe", new Object[0]));
            return;
        }
        Vec3d vec3d = player.func_174824_e(1.0f);
        Vec3d vec3d1 = player.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * 32.0, vec3d1.field_72448_b * 32.0, vec3d1.field_72449_c * 32.0);
        RayTraceResult result = player.field_70170_p.func_72933_a(vec3d, vec3d2);
        if (result.field_72313_a != RayTraceResult.Type.BLOCK) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.recipe.generate.exception.not_looking_at_block", new Object[0]));
            return;
        }
        BlockPos basePos = result.func_178782_a().func_177967_a(result.field_178784_b, 1);
        EnumFacing zDir = dir = BlockFieldProjector.getFacingFromEntity(basePos, (EntityLivingBase)player);
        EnumFacing yDir = EnumFacing.UP;
        EnumFacing xDir = dir.func_176746_e();
        for (int x = 0; x < recipe.getWidth(); ++x) {
            for (int y = 0; y < recipe.getHeight(); ++y) {
                for (int z = 0; z < recipe.getDepth(); ++z) {
                    BlockPos livePos = basePos.func_177967_a(xDir, x);
                    livePos = livePos.func_177967_a(yDir, y);
                    livePos = livePos.func_177967_a(zDir, z);
                    IBlockState state = recipe.getStateAtBlockPos(new BlockPos(x, y, z));
                    player.field_70170_p.func_180501_a(livePos, state, 2);
                }
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        List<String> allRecipes = MultiblockRecipes.getRecipes().stream().map(multiblockRecipe -> multiblockRecipe.getName()).filter(s -> args.length == 0 || s.startsWith(args[0])).collect(Collectors.toList());
        return allRecipes;
    }
}

