/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.dave.compactmachines3.command.CommandBaseExt;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.network.MessageClipboard;
import org.dave.compactmachines3.network.PackageHandler;
import org.dave.compactmachines3.tile.TileEntityFieldProjector;
import org.dave.compactmachines3.utility.SerializationHelper;
import org.dave.compactmachines3.world.data.provider.AbstractExtraTileDataProvider;
import org.dave.compactmachines3.world.data.provider.ExtraTileDataProviderRegistry;

public class CommandRecipeCopyShape
extends CommandBaseExt {
    public String func_71517_b() {
        return "copy-shape";
    }

    @Override
    public boolean isAllowed(EntityPlayer player, boolean creative, boolean isOp) {
        return creative || isOp;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender.func_174793_f() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender.func_174793_f();
        Vec3d vec3d = player.func_174824_e(1.0f);
        Vec3d vec3d1 = player.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * 32.0, vec3d1.field_72448_b * 32.0, vec3d1.field_72449_c * 32.0);
        RayTraceResult result = player.field_70170_p.func_72933_a(vec3d, vec3d2);
        if (result.field_72313_a != RayTraceResult.Type.BLOCK) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.recipe.copy-shape.exception.not_looking_at_projector", new Object[0]));
            return;
        }
        IBlockState blockState = sender.func_130014_f_().func_180495_p(result.func_178782_a());
        if (blockState.func_177230_c() != Blockss.fieldProjector) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.recipe.copy-shape.exception.not_looking_at_projector", new Object[0]));
            return;
        }
        if (!(sender.func_130014_f_().func_175625_s(result.func_178782_a()) instanceof TileEntityFieldProjector)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.recipe.copy-shape.exception.not_looking_at_projector", new Object[0]));
            return;
        }
        TileEntityFieldProjector teProjector = (TileEntityFieldProjector)sender.func_130014_f_().func_175625_s(result.func_178782_a());
        List<BlockPos> insideBlocks = teProjector.getInsideBlocks();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : insideBlocks) {
            if (pos.func_177958_n() < minX) {
                minX = pos.func_177958_n();
            }
            if (pos.func_177956_o() < minY) {
                minY = pos.func_177956_o();
            }
            if (pos.func_177952_p() < minZ) {
                minZ = pos.func_177952_p();
            }
            if (pos.func_177958_n() > maxX) {
                maxX = pos.func_177958_n();
            }
            if (pos.func_177956_o() > maxY) {
                maxY = pos.func_177956_o();
            }
            if (pos.func_177952_p() <= maxZ) continue;
            maxZ = pos.func_177952_p();
        }
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        int depth = maxZ - minZ + 1;
        String[][][] array = new String[width][height][depth];
        JsonObject resultObj = new JsonObject();
        JsonObject inputTypes = new JsonObject();
        JsonObject variants = new JsonObject();
        resultObj.add("input-types", (JsonElement)inputTypes);
        char nextRef = 'a';
        HashMap<String, Character> nextVariant = new HashMap<String, Character>();
        HashMap<String, String> refMap = new HashMap<String, String>();
        HashMap variantMap = new HashMap();
        for (BlockPos pos : insideBlocks) {
            String refName;
            String fullName;
            IBlockState state = sender.func_130014_f_().func_180495_p(pos);
            String blockName = state.func_177230_c().getRegistryName().toString();
            int meta = state.func_177230_c().func_176201_c(state);
            TileEntity te = sender.func_130014_f_().func_175625_s(pos);
            String nbtDataString = null;
            if (state.func_177230_c().hasTileEntity(state) && te != null) {
                NBTTagCompound nbtData = te.func_189515_b(new NBTTagCompound());
                nbtData.func_82580_o("x");
                nbtData.func_82580_o("y");
                nbtData.func_82580_o("z");
                for (AbstractExtraTileDataProvider provider : ExtraTileDataProviderRegistry.getDataProviders(te)) {
                    NBTTagCompound extraData = provider.writeExtraData(te);
                    String tagName = String.format("cm3_extra:%s", provider.getName());
                    nbtData.func_74782_a(tagName, (NBTBase)extraData);
                }
                nbtDataString = nbtData.toString();
            }
            if (refMap.containsKey(fullName = blockName + ":" + meta)) {
                refName = (String)refMap.get(fullName);
            } else {
                char c = nextRef;
                nextRef = (char)(nextRef + 1);
                refName = "" + c;
                refMap.put(fullName, refName);
                JsonObject typeDescription = new JsonObject();
                typeDescription.addProperty("id", blockName);
                typeDescription.addProperty("meta", (Number)meta);
                inputTypes.add(refName, (JsonElement)typeDescription);
            }
            if (!nextVariant.containsKey(refName)) {
                nextVariant.put(refName, Character.valueOf('A'));
            }
            String variantName = null;
            if (nbtDataString != null) {
                HashMap thisRefsVariantMap;
                if (!variantMap.containsKey(refName)) {
                    variantMap.put(refName, new HashMap());
                }
                if ((thisRefsVariantMap = (HashMap)variantMap.get(refName)).containsKey(nbtDataString)) {
                    variantName = (String)thisRefsVariantMap.get(nbtDataString);
                } else {
                    char variant;
                    char c = variant = ((Character)nextVariant.get(refName)).charValue();
                    variant = (char)(variant + '\u0001');
                    variantName = "" + c;
                    nextVariant.put(refName, Character.valueOf(variant));
                    thisRefsVariantMap.put(nbtDataString, variantName);
                    JsonObject variantData = new JsonObject();
                    variantData.addProperty("nbt", nbtDataString);
                    variants.add(refName + ":" + variantName, (JsonElement)variantData);
                }
            }
            BlockPos relative = pos.func_177982_a(-minX, -minY, -minZ);
            if (variantName != null) {
                array[relative.func_177958_n()][relative.func_177956_o()][relative.func_177952_p()] = refName + ":" + variantName;
                continue;
            }
            array[relative.func_177958_n()][relative.func_177956_o()][relative.func_177952_p()] = refName;
        }
        if (variants.size() > 0) {
            resultObj.add("input-nbt", (JsonElement)variants);
        }
        JsonArray yArr = new JsonArray();
        for (int y = height - 1; y >= 0; --y) {
            JsonArray zArr = new JsonArray();
            for (int z = 0; z < depth; ++z) {
                JsonArray xArr = new JsonArray();
                for (int x = 0; x < width; ++x) {
                    if (array[x][y][z] == null) {
                        xArr.add("_");
                        continue;
                    }
                    xArr.add(array[x][y][z]);
                }
                zArr.add((JsonElement)xArr);
            }
            yArr.add((JsonElement)zArr);
        }
        resultObj.add("shape", (JsonElement)yArr);
        MessageClipboard message = new MessageClipboard();
        String rawJson = SerializationHelper.GSON.toJson((JsonElement)resultObj);
        message.setClipboardContent(rawJson.substring(1, rawJson.length() - 1));
        PackageHandler.instance.sendTo((IMessage)message, (EntityPlayerMP)sender.func_174793_f());
        player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.recipe.copy-shape.success", new Object[0]));
    }
}

