/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.dave.compactmachines3.command.CommandBaseExt;
import org.dave.compactmachines3.network.MessageClipboard;
import org.dave.compactmachines3.network.PackageHandler;
import org.dave.compactmachines3.utility.SerializationHelper;

public class CommandRecipeCopyItem
extends CommandBaseExt {
    public String func_71517_b() {
        return "copy-item";
    }

    @Override
    public boolean isAllowed(EntityPlayer player, boolean creative, boolean isOp) {
        return creative || isOp;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender.func_174793_f() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender.func_174793_f();
        if (args.length != 1 || !args[0].equalsIgnoreCase("catalyst") && !args[0].equalsIgnoreCase("target")) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.recipe.copy-item.exception.missing_type", new Object[0]));
            player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.recipe.copy-item.usage", new Object[0]));
            return;
        }
        String prefix = args[0].toLowerCase();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.recipe.copy-item.exception.missing_item", new Object[0]));
            return;
        }
        String suffix = "item";
        if (stack.func_77973_b() instanceof ItemBlock) {
            suffix = "block";
        }
        JsonObject resultObj = new JsonObject();
        if (prefix.equals("catalyst")) {
            resultObj.addProperty("catalyst", stack.func_77973_b().getRegistryName().toString());
        } else {
            resultObj.addProperty(prefix + "-" + suffix, stack.func_77973_b().getRegistryName().toString());
            resultObj.addProperty(prefix + "-count", (Number)stack.func_190916_E());
        }
        resultObj.addProperty(prefix + "-meta", (Number)stack.func_77960_j());
        if (stack.func_77942_o()) {
            resultObj.addProperty(prefix + "-nbt", stack.func_77978_p().toString());
        }
        MessageClipboard message = new MessageClipboard();
        String rawJson = SerializationHelper.GSON.toJson((JsonElement)resultObj);
        message.setClipboardContent(rawJson.substring(1, rawJson.length() - 2) + ",");
        PackageHandler.instance.sendTo((IMessage)message, (EntityPlayerMP)sender.func_174793_f());
        player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.recipe.copy-item.success", new Object[0]));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        List<String> options = Arrays.asList("target", "catalyst");
        return options.stream().filter(s -> args.length == 0 || s.startsWith(args[0])).collect(Collectors.toList());
    }
}

