/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.number;

import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceOperator;

public class PieceOperatorLog
extends PieceOperator {
    SpellParam num;
    SpellParam base;

    public PieceOperatorLog(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.num = new ParamNumber("psi.spellparam.target", SpellParam.BLUE, false, false);
        this.addParam(this.num);
        this.base = new ParamNumber("psi.spellparam.base", SpellParam.RED, true, false);
        this.addParam(this.base);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Double d = (Double)this.getParamValue(context, this.num);
        if (d < 0.0) {
            throw new SpellRuntimeException("psi.spellerror.negativenumber");
        }
        double logNum = Math.log10(d);
        Double b = (Double)this.getParamValue(context, this.base);
        if (b != null) {
            if (b < 0.0) {
                throw new SpellRuntimeException("psi.spellerror.negativenumber");
            }
            logNum /= Math.log10(b);
        }
        return logNum;
    }

    @Override
    public Class<?> getEvaluationType() {
        return Double.class;
    }
}

