/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.common.core.handler.ConfigHandler;

@SideOnly(value=Side.CLIENT)
public final class PersistencyHandler {
    private static boolean doneInit = false;
    private static File persistentFile;
    public static int persistentLevel;
    public static boolean ignore;

    public static void init() {
        if (doneInit) {
            return;
        }
        doneInit = true;
        if (!ConfigHandler.usePersistentData) {
            return;
        }
        String userhome = System.getProperty("user.home");
        String os = System.getProperty("os.name");
        userhome = os.startsWith("Windows") ? userhome + "\\AppData\\Roaming\\.minecraft\\psi_persistent" : (os.startsWith("Mac") ? userhome + "/Library/Application Support/minecraft/psi_persistent" : userhome + "/.minecraft/psi_persistent");
        File dir = new File(userhome);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Couldn't create home directory!");
        }
        File info = new File(userhome, "info.txt");
        if (!info.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(info));){
                if (info.createNewFile()) {
                    writer.write("This is Psi's Persistent Data directory.\n");
                    writer.write("Files stored here are persistent info on what levels each player has gotten to.\n");
                    writer.write("The files in here are the same for every instance and modpack you play, they always end up here.\n");
                    writer.write("This allows you to skip tutorials on new worlds or even new modpacks.\n");
                    writer.write("\n");
                    writer.write("If you wish to disable this feature, you can turn it off in the Psi config file.");
                    writer.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Minecraft mc = Minecraft.func_71410_x();
        String uuid = EntityPlayer.func_146094_a((GameProfile)mc.field_71439_g.func_146103_bH()).toString();
        persistentFile = new File(userhome, uuid);
        if (persistentFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(persistentFile));){
                String l = reader.readLine();
                if (l != null) {
                    int n = Integer.parseInt(l.trim());
                    persistentLevel = n = Math.min(n, PsiAPI.levelCap);
                }
            }
            catch (IOException | NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save(int level) {
        block16: {
            if (!doneInit) {
                PersistencyHandler.init();
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (!ConfigHandler.usePersistentData || level <= persistentLevel || mc.field_71439_g == null || mc.field_71439_g.field_71075_bZ.field_75098_d) {
                return;
            }
            try {
                if (persistentFile == null || !persistentFile.exists() && !persistentFile.createNewFile()) break block16;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(persistentFile));){
                    writer.write("" + level);
                    writer.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        ignore = false;
    }
}

