/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.PieceGroup;
import vazkii.psi.common.command.CommandPsiLearn;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public class CommandPsiUnlearn
extends CommandPsiLearn {
    @Override
    @Nonnull
    public String func_71517_b() {
        return "psi-unlearn";
    }

    @Override
    public String localizationKey() {
        return "command.psi.unlearn";
    }

    @Override
    public boolean shouldNotApply(EntityPlayer player, String group) {
        return !super.shouldNotApply(player, group);
    }

    @Override
    public void applyPlayerData(EntityPlayer player, PlayerDataHandler.PlayerData data, String group, ICommandSender sender) {
        if (group.equals("psidust")) {
            CommandPsiUnlearn.lockPieceGroup(data, group);
            this.notify(sender, "success", player.func_145748_c_(), CommandPsiUnlearn.getGroupComponent(group));
        } else if (CommandPsiUnlearn.getGroups().contains(group)) {
            ArrayList superGroups = Lists.newArrayList(data.spellGroupsUnlocked);
            for (String superGroup : superGroups) {
                PieceGroup superPieceGroup;
                if (!data.isPieceGroupUnlocked(superGroup) || (superPieceGroup = PsiAPI.groupsForName.get(group)) == null || !superPieceGroup.requirements.contains(group)) continue;
                this.applyPlayerData(player, data, superGroup, sender);
            }
            if (data.isPieceGroupUnlocked(group)) {
                CommandPsiUnlearn.lockPieceGroup(data, group);
                this.notify(sender, "success", player.func_145748_c_(), CommandPsiUnlearn.getGroupComponent(group));
            }
        }
    }

    @Override
    public void applyAll(PlayerDataHandler.PlayerData data, EntityPlayer player, ICommandSender sender) {
        CommandPsiUnlearn.lockAll(data);
        this.notify(sender, "success.all", player.func_145748_c_());
    }
}

