/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.arl.network.NetworkHandler;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.PieceGroup;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.message.MessageDataSync;

public class CommandPsiLearn
extends CommandBase {
    public static final String level0 = "psidust";
    private static List<String> groups;

    public static List<String> getGroups() {
        if (groups == null) {
            groups = Lists.newArrayList((Object[])new String[]{level0});
            groups.addAll(PsiAPI.groupsForName.keySet());
        }
        return groups;
    }

    public static void lockPieceGroup(PlayerDataHandler.PlayerData data, String group) {
        if (CommandPsiLearn.hasGroup(data, group)) {
            if (group.equals(level0)) {
                data.level = 0;
            } else {
                data.spellGroupsUnlocked.remove(group);
                --data.level;
            }
            data.save();
        }
    }

    public static void unlockPieceGroupFree(PlayerDataHandler.PlayerData data, String group) {
        if (!CommandPsiLearn.hasGroup(data, group)) {
            if (group.equals(level0)) {
                if (data.level == 0) {
                    ++data.level;
                    data.levelPoints = 1;
                    data.lastSpellGroup = "";
                    data.learning = false;
                }
            } else {
                data.spellGroupsUnlocked.add(group);
                data.lastSpellGroup = "";
                ++data.level;
                data.learning = false;
            }
            data.save();
        }
    }

    public static void unlockAll(PlayerDataHandler.PlayerData data) {
        for (String group : CommandPsiLearn.getGroups()) {
            if (CommandPsiLearn.hasGroup(data, group)) continue;
            CommandPsiLearn.unlockPieceGroupFree(data, group);
        }
        data.lastSpellGroup = "";
        data.learning = false;
        data.save();
    }

    public static void lockAll(PlayerDataHandler.PlayerData data) {
        ArrayList unlocked = Lists.newArrayList(data.spellGroupsUnlocked);
        for (String group : unlocked) {
            CommandPsiLearn.lockPieceGroup(data, group);
        }
        data.level = 0;
        data.levelPoints = 0;
        data.save();
    }

    public static boolean hasGroup(PlayerDataHandler.PlayerData data, String group) {
        if (data == null) {
            return false;
        }
        if (group.equals(level0)) {
            return data.level > 0;
        }
        return data.isPieceGroupUnlocked(group);
    }

    public static boolean hasGroup(EntityPlayer player, String group) {
        return CommandPsiLearn.hasGroup(PlayerDataHandler.get(player), group);
    }

    public static ITextComponent getGroupComponent(String group) {
        if (group.equals(level0)) {
            ITextComponent nameComponent = new TextComponentString("[").func_150257_a((ITextComponent)new TextComponentTranslation("psimisc.fakeLevel.psidust", new Object[0])).func_150258_a("]");
            nameComponent.func_150256_b().func_150238_a(TextFormatting.AQUA);
            nameComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("psimisc.levelDisplay", new Object[]{0})));
            return nameComponent;
        }
        PieceGroup pieceGroup = PsiAPI.groupsForName.get(group);
        if (pieceGroup == null) {
            TextComponentString errorComponent = new TextComponentString("ERROR");
            errorComponent.func_150256_b().func_150238_a(TextFormatting.RED);
            return errorComponent;
        }
        ITextComponent nameComponent = new TextComponentString("[").func_150257_a((ITextComponent)new TextComponentTranslation(pieceGroup.getUnlocalizedName(), new Object[0])).func_150258_a("]");
        nameComponent.func_150256_b().func_150238_a(TextFormatting.AQUA);
        nameComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("psimisc.levelDisplay", new Object[]{pieceGroup.levelRequirement})));
        return nameComponent;
    }

    public String localizationKey() {
        return "command.psi.learn";
    }

    @Nonnull
    public String func_71517_b() {
        return "psi-learn";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return this.localizationKey() + ".usage";
    }

    public int func_82362_a() {
        return 2;
    }

    protected void notify(ICommandSender sender, String result, Object ... format) {
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(this.localizationKey() + "." + result), (Object[])format);
    }

    protected void wrongUsage(ICommandSender sender) throws WrongUsageException {
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    protected void error(String result, Object ... format) throws CommandException {
        throw new CommandException(this.localizationKey() + "." + result, format);
    }

    public void applyPlayerData(EntityPlayer player, PlayerDataHandler.PlayerData data, String group, ICommandSender sender) {
        PieceGroup pieceGroup;
        CommandPsiLearn.unlockPieceGroupFree(data, level0);
        if (group.equals(level0)) {
            this.notify(sender, "success", player.func_145748_c_(), CommandPsiLearn.getGroupComponent(group));
        } else if (CommandPsiLearn.getGroups().contains(group) && (pieceGroup = PsiAPI.groupsForName.get(group)) != null && !data.isPieceGroupUnlocked(group)) {
            for (String subGroup : pieceGroup.requirements) {
                if (data.isPieceGroupUnlocked(subGroup)) continue;
                this.applyPlayerData(player, data, subGroup, sender);
            }
            CommandPsiLearn.unlockPieceGroupFree(data, group);
            this.notify(sender, "success", player.func_145748_c_(), CommandPsiLearn.getGroupComponent(group));
        }
    }

    public void applyAll(PlayerDataHandler.PlayerData data, EntityPlayer player, ICommandSender sender) {
        CommandPsiLearn.unlockAll(data);
        this.notify(sender, "success.all", player.func_145748_c_());
    }

    public boolean shouldNotApply(EntityPlayer player, String group) {
        return CommandPsiLearn.hasGroup(player, group);
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length == 0 || args.length > 3) {
            this.wrongUsage(sender);
        } else {
            Entity target = args.length == 2 ? CommandBase.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[1]) : sender.func_174793_f();
            if (target == null) {
                this.error("console", new Object[0]);
            } else if (!(target instanceof EntityPlayer)) {
                this.error("players", target.func_145748_c_());
            } else {
                EntityPlayer player = (EntityPlayer)target;
                PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
                if (args[0].equals("*")) {
                    this.applyAll(data, player, sender);
                    if (player instanceof EntityPlayerMP) {
                        NetworkHandler.INSTANCE.sendTo((IMessage)new MessageDataSync(data), (EntityPlayerMP)player);
                    }
                } else if (!CommandPsiLearn.getGroups().contains(args[0])) {
                    this.error("not_a_group", args[0]);
                } else if (this.shouldNotApply(player, args[0])) {
                    this.error("should_not", player.func_145748_c_(), args[0]);
                } else {
                    this.applyPlayerData(player, data, args[0], sender);
                    if (player instanceof EntityPlayerMP) {
                        NetworkHandler.INSTANCE.sendTo((IMessage)new MessageDataSync(data), (EntityPlayerMP)player);
                    }
                }
            }
        }
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 1;
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        switch (args.length) {
            case 1: {
                return CommandBase.func_175762_a((String[])args, CommandPsiLearn.getGroups());
            }
            case 2: {
                return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
        }
        return Collections.emptyList();
    }
}

