/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.spell.SpellPiece;

public class PieceGroup
implements Comparable<PieceGroup> {
    public final String name;
    public final List<Class<? extends SpellPiece>> pieces = new ArrayList<Class<? extends SpellPiece>>();
    public Class<? extends SpellPiece> mainPiece = null;
    public List<String> requirements = new ArrayList<String>();
    public int levelRequirement = 0;

    public PieceGroup(String name) {
        this.name = name;
    }

    public void addPiece(Class<? extends SpellPiece> piece, boolean main) {
        this.pieces.add(piece);
        if (main) {
            this.mainPiece = piece;
        }
    }

    public void setRequirements(int level, String ... reqs) {
        this.levelRequirement = level;
        this.requirements = Arrays.asList(reqs);
    }

    public boolean isAvailable(IPlayerData data) {
        if (data.getLevel() < this.levelRequirement) {
            return false;
        }
        for (String s : this.requirements) {
            if (data.isPieceGroupUnlocked(s)) continue;
            return false;
        }
        return true;
    }

    public String getUnlocalizedName() {
        return "psi.piecegroup." + this.name;
    }

    public String getUnlocalizedDesc() {
        return this.getUnlocalizedName() + ".desc";
    }

    @Override
    public int compareTo(@Nonnull PieceGroup o) {
        if (o.levelRequirement == this.levelRequirement) {
            return TooltipHelper.local(this.getUnlocalizedName()).compareTo(TooltipHelper.local(o.getUnlocalizedName()));
        }
        return this.levelRequirement - o.levelRequirement;
    }
}

