/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw;

import java.util.function.Function;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.simple.SimpleLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import portablejim.bbw.containers.ContainerManager;
import portablejim.bbw.containers.ContainerRegistrar;
import portablejim.bbw.core.ConfigValues;
import portablejim.bbw.core.OopsCommand;
import portablejim.bbw.core.conversion.CustomMappingManager;
import portablejim.bbw.core.conversion.StackedBlockManager;
import portablejim.bbw.core.items.ItemRestrictedWandAdvanced;
import portablejim.bbw.core.items.ItemRestrictedWandBasic;
import portablejim.bbw.core.items.ItemUnrestrictedWand;
import portablejim.bbw.core.wands.RestrictedWand;
import portablejim.bbw.core.wands.UnbreakingWand;
import portablejim.bbw.network.PacketWandActivate;
import portablejim.bbw.proxy.IProxy;

@Mod(modid="betterbuilderswands", acceptedMinecraftVersions="[1.12,1.13)")
public class BetterBuildersWandsMod {
    public static final String MODID = "betterbuilderswands";
    public static final String LANGID = "bbw";
    @Mod.Instance
    public static BetterBuildersWandsMod instance;
    @SidedProxy(modId="betterbuilderswands", clientSide="portablejim.bbw.proxy.ClientProxy", serverSide="portablejim.bbw.proxy.ServerProxy")
    public static IProxy proxy;
    public ConfigValues configValues;
    public ContainerManager containerManager = new ContainerManager();
    public static Logger logger;
    public static ItemRestrictedWandBasic itemStoneWand;
    public static ItemRestrictedWandAdvanced itemIronWand;
    public static ItemUnrestrictedWand itemDiamondWand;
    public static ItemUnrestrictedWand itemUnbreakableWand;
    public SimpleNetworkWrapper networkWrapper;
    public StackedBlockManager blockCache;
    public CustomMappingManager mappingManager;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.configValues = new ConfigValues(event.getSuggestedConfigurationFile());
        this.configValues.loadConfigFile();
        this.networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("bbwands");
        this.networkWrapper.registerMessage(PacketWandActivate.Handler.class, PacketWandActivate.class, 0, Side.SERVER);
        int diamondWandLimit = this.configValues.DIAMOND_WAND_LIMIT < 0 ? Item.ToolMaterial.DIAMOND.func_77997_a() : this.configValues.DIAMOND_WAND_LIMIT;
        itemStoneWand = new ItemRestrictedWandBasic(new RestrictedWand(5));
        itemIronWand = new ItemRestrictedWandAdvanced(new RestrictedWand(9));
        itemDiamondWand = new ItemUnrestrictedWand(new RestrictedWand(diamondWandLimit), "unrestricted", "diamond");
        itemDiamondWand.func_77656_e(Item.ToolMaterial.DIAMOND.func_77997_a());
        itemUnbreakableWand = new ItemUnrestrictedWand(new UnbreakingWand(), "unbreakable", "unbreakable");
        itemStoneWand.setRegistryName("wandStone");
        itemIronWand.setRegistryName("wandIron");
        itemDiamondWand.setRegistryName("wandDiamond");
        itemUnbreakableWand.setRegistryName("wandUnbreakable");
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.blockCache = new StackedBlockManager();
        this.mappingManager = new CustomMappingManager();
    }

    @SubscribeEvent
    public void registration(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)itemStoneWand);
        event.getRegistry().register((IForgeRegistryEntry)itemIronWand);
        event.getRegistry().register((IForgeRegistryEntry)itemDiamondWand);
        event.getRegistry().register((IForgeRegistryEntry)itemUnbreakableWand);
    }

    private IRecipe wandRecipe(String variant, Item output, String material) {
        return this.wandRecipe(variant, new ItemStack(output), material);
    }

    private IRecipe wandRecipe(String variant, ItemStack output, String material) {
        ResourceLocation recipeName = new ResourceLocation(MODID, "recipewand" + variant);
        ShapedOreRecipe recipe = new ShapedOreRecipe(recipeName, output, new Object[]{"  H", " S ", "S  ", Character.valueOf('S'), "stickWood", Character.valueOf('H'), material});
        recipe.setRegistryName(recipeName);
        return recipe;
    }

    private IRecipe wandRecipe(String variant, ItemStack output, Item material) {
        ResourceLocation recipeName = new ResourceLocation(MODID, "recipewand" + variant);
        ShapedOreRecipe recipe = new ShapedOreRecipe(recipeName, output, new Object[]{"  H", " S ", "S  ", Character.valueOf('S'), "stickWood", Character.valueOf('H'), material});
        recipe.setRegistryName(recipeName);
        return recipe;
    }

    @SubscribeEvent
    public void recipes(RegistryEvent.Register<IRecipe> event) {
        boolean EXTRA_UTILS_RECIPES;
        if (this.configValues.ENABLE_STONE_WAND) {
            event.getRegistry().register((IForgeRegistryEntry)this.wandRecipe("stone", itemStoneWand, "cobblestone"));
        }
        if (this.configValues.ENABLE_IRON_WAND) {
            event.getRegistry().register((IForgeRegistryEntry)this.wandRecipe("iron", itemIronWand, "ingotIron"));
        }
        if (this.configValues.ENABLE_DIAMOND_WAND) {
            event.getRegistry().register((IForgeRegistryEntry)this.wandRecipe("diamond", itemDiamondWand, "gemDiamond"));
        }
        Function<Integer, Boolean> unbreakableWandRecipe = damage -> {
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(MODID, "wandunbreakable" + damage), (ResourceLocation)new ResourceLocation(MODID, "wandunbreakable" + damage), (ItemStack)this.newWand((int)damage), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.newWand(damage - 1)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.newWand(damage - 1)})});
            return true;
        };
        boolean bl = EXTRA_UTILS_RECIPES = !this.configValues.NO_EXTRA_UTILS_RECIPES;
        if (Loader.isModLoaded((String)"ExtraUtilities") && EXTRA_UTILS_RECIPES) {
            Item buildersWand = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ExtraUtilities", "builderswand"));
            Item creativebuildersWand = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ExtraUtilities", "creativebuilderswand"));
            event.getRegistry().register((IForgeRegistryEntry)this.wandRecipe("unbreakabletiny", this.newWand(4), buildersWand));
            event.getRegistry().register((IForgeRegistryEntry)this.wandRecipe("unbreakable", this.newWand(12), creativebuildersWand));
            unbreakableWandRecipe.apply(5);
            unbreakableWandRecipe.apply(6);
        } else {
            event.getRegistry().register((IForgeRegistryEntry)this.wandRecipe("unbreakable", this.newWand(12), "netherStar"));
        }
        unbreakableWandRecipe.apply(13);
        unbreakableWandRecipe.apply(14);
    }

    @SubscribeEvent
    public void models(ModelRegistryEvent event) {
        proxy.RegisterModels();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.mappingManager.loadConfig(this.configValues.OVERRIDES_RECIPES);
    }

    private ItemStack newWand(int damage) {
        return new ItemStack((Item)itemUnbreakableWand, 1, damage);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        boolean EXTRA_UTILS_RECIPES;
        proxy.RegisterEvents();
        boolean bl = EXTRA_UTILS_RECIPES = !this.configValues.NO_EXTRA_UTILS_RECIPES;
        if (Loader.isModLoaded((String)"ExtraUtilities") && EXTRA_UTILS_RECIPES) {
            itemUnbreakableWand.addSubMeta(4);
            itemUnbreakableWand.addSubMeta(5);
            itemUnbreakableWand.addSubMeta(6);
        }
        itemUnbreakableWand.addSubMeta(12);
        itemUnbreakableWand.addSubMeta(13);
        itemUnbreakableWand.addSubMeta(14);
        ContainerRegistrar.register();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new OopsCommand());
    }

    static {
        logger = new SimpleLogger("BetterBuildersWand", Level.ALL, true, false, true, false, "YYYY-MM-DD", null, PropertiesUtil.getProperties(), null);
    }
}

