/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.tiles;

import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.DuctItem;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.energy.DuctUnitEnergy;
import cofh.thermaldynamics.duct.energy.GridEnergy;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluidOmni;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGridStructureBase;
import javax.annotation.Nonnull;

public class TileDuctOmni
extends TileGridStructureBase
implements IEnergyReceiver {
    public TileDuctOmni(DuctItem ductType) {
        DuctUnitEnergy energy = new DuctUnitEnergy(this, ductType, 1000, 1000){

            @Override
            public boolean canConnectToOtherDuct(DuctUnit<DuctUnitEnergy, GridEnergy, IEnergyReceiver> adjDuct, byte side, byte oppositeSide) {
                return super.canConnectToOtherDuct(adjDuct, side, oppositeSide) && (adjDuct.getDuctType() == TDDucts.itemOmni || adjDuct.getDuctType() == TDDucts.itemOmniOpaque);
            }

            @Override
            @Nonnull
            protected BlockDuct.ConnectionType getConnectionTypeDuct(DuctUnitEnergy duct, int side) {
                return BlockDuct.ConnectionType.CLEAN_DUCT;
            }
        };
        this.addDuctUnits(DuctToken.ENERGY, energy);
        this.addDuctUnits(DuctToken.ITEMS, new DuctUnitItem(this, ductType));
        this.addDuctUnits(DuctToken.FLUID, new DuctUnitFluidOmni(this, ductType));
    }

    @Override
    protected DuctToken getPrimaryDuctToken() {
        return DuctToken.ITEMS;
    }

    public static class Opaque
    extends TileDuctOmni {
        public Opaque() {
            super(TDDucts.itemOmniOpaque);
        }
    }

    public static class Transparent
    extends TileDuctOmni {
        public Transparent() {
            super(TDDucts.itemOmni);
        }
    }
}

