/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.filter;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.thermaldynamics.duct.attachments.ConnectionBase;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.init.TDItems;
import cofh.thermaldynamics.init.TDTextures;
import cofh.thermaldynamics.render.RenderDuct;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class FilterBase
extends ConnectionBase {
    public FilterBase(TileGrid tile, byte side) {
        super(tile, side);
    }

    public FilterBase(TileGrid tile, byte side, int type) {
        super(tile, side, type);
    }

    @Override
    public boolean isFilter() {
        return true;
    }

    @Override
    public boolean isServo() {
        return false;
    }

    @Override
    public boolean canSend() {
        return true;
    }

    @Override
    public String getName() {
        return "item.thermaldynamics.filter." + this.type + ".name";
    }

    @Override
    public ItemStack getPickBlock() {
        return new ItemStack((Item)TDItems.itemFilter, 1, this.type);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.CUTOUT) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[this.stuffed ? 2 : 1][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TDTextures.FILTER_BASE[this.type])});
        return true;
    }

    @Override
    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        super.writePortableData(player, tag);
        tag.func_74778_a("DisplayType", "item.thermaldynamics.filter.0.name");
    }
}

