/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.IDuctFactory;
import cofh.thermaldynamics.render.TextureOverlay;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DuctItem
extends Duct {
    public static final String PATHWEIGHT_NBT = "DenseType";
    public static final byte PATHWEIGHT_DENSE = 1;
    public static final byte PATHWEIGHT_VACUUM = 2;
    public TextureAtlasSprite iconBaseTextureVacuum;
    public TextureAtlasSprite iconBaseTextureDense;

    public DuctItem(int id, boolean opaque, int pathWeight, int type, String name, Duct.Type ductType, IDuctFactory factory, String baseTexture, String connectionTexture, String fluidTexture, int fluidTransparency, String frameTexture, String frameFluidTexture, int frameFluidTransparency) {
        super(id, opaque, pathWeight, type, name, ductType, factory, baseTexture, connectionTexture, fluidTexture, fluidTransparency, frameTexture, frameFluidTexture, frameFluidTransparency);
    }

    @Override
    public void registerIcons(TextureMap textureMap) {
        super.registerIcons(textureMap);
        this.iconBaseTextureVacuum = TextureOverlay.generateBaseTexture(textureMap, this.baseTexture, this.opaque ? null : "trans", "vacuum");
        this.iconBaseTextureDense = TextureOverlay.generateBaseTexture(textureMap, this.baseTexture, this.opaque ? null : "trans", "dense");
    }

    @Override
    public TextureAtlasSprite getBaseTexture(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            byte b = itemStack.func_77978_p().func_74771_c(PATHWEIGHT_NBT);
            if (b == 1) {
                return this.iconBaseTextureDense;
            }
            if (b == 2) {
                return this.iconBaseTextureVacuum;
            }
        }
        return super.getBaseTexture(itemStack);
    }

    public ItemStack getDenseItemStack() {
        ItemStack item = this.itemStack.func_77946_l();
        item.func_77982_d(new NBTTagCompound());
        item.func_77978_p().func_74774_a(PATHWEIGHT_NBT, (byte)1);
        return item;
    }

    public ItemStack getVacuumItemStack() {
        ItemStack item = this.itemStack.func_77946_l();
        item.func_77982_d(new NBTTagCompound());
        item.func_77978_p().func_74774_a(PATHWEIGHT_NBT, (byte)2);
        return item;
    }
}

