/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.sequencer;

import binnie.core.gui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.sequencer.Sequencer;
import binnie.genetics.machine.sequencer.SequencerFX;
import binnie.genetics.machine.sequencer.SequencerLogic;
import binnie.genetics.machine.sequencer.SlotValidatorUnsequenced;
import binnie.genetics.modules.ModuleMachine;
import net.minecraft.tileentity.TileEntity;

public class PackageSequencer
extends GeneticMachine.PackageGeneticBase
implements IMachineInformation {
    public PackageSequencer() {
        super("sequencer", 12058418);
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.SEQUENCER);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot slotDye = inventory.addSlot(0, this.getSlotRL("dye"));
        slotDye.setValidator(new SlotValidator.Item(GeneticsItems.FluorescentDye.get(1), ModuleMachine.getSpriteDye()));
        slotDye.forbidExtraction();
        for (InventorySlot slot : inventory.addSlotArray(Sequencer.SLOT_RESERVE, this.getSlotRL("input"))) {
            slot.setValidator(new SlotValidatorUnsequenced());
            slot.forbidExtraction();
        }
        InventorySlot slotTarget = inventory.addSlot(5, this.getSlotRL("process"));
        slotTarget.setValidator(new SlotValidatorUnsequenced());
        slotTarget.setReadOnly();
        slotTarget.forbidInteraction();
        InventorySlot slotDone = inventory.addSlot(6, this.getSlotRL("output"));
        slotDone.setReadOnly();
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Sequencer.SLOT_RESERVE, 5, 1);
        new ComponentChargedSlots(machine).addCharge(0);
        new ComponentPowerReceptor(machine, 10000);
        new SequencerLogic(machine);
        new SequencerFX(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }
}

