/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.wood.planks;

import binnie.core.util.I18N;
import binnie.extratrees.wood.IFenceProvider;
import binnie.extratrees.wood.planks.IPlankType;
import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum ForestryPlanks implements IPlankType,
IFenceProvider
{
    LARCH(14131085, (IWoodType)EnumForestryWoodType.LARCH),
    TEAK(8223075, (IWoodType)EnumForestryWoodType.TEAK),
    ACACIA(9745287, (IWoodType)EnumForestryWoodType.ACACIA),
    LIME(13544048, (IWoodType)EnumForestryWoodType.LIME),
    CHESTNUT(12298845, (IWoodType)EnumForestryWoodType.CHESTNUT),
    WENGE(6182474, (IWoodType)EnumForestryWoodType.WENGE),
    BAOBAB(9608290, (IWoodType)EnumForestryWoodType.BAOBAB),
    SEQUOIA(10050135, (IWoodType)EnumForestryWoodType.SEQUOIA),
    KAPOK(8156212, (IWoodType)EnumForestryWoodType.KAPOK),
    EBONY(3946288, (IWoodType)EnumForestryWoodType.EBONY),
    MAHOGANY(7749432, (IWoodType)EnumForestryWoodType.MAHOGANY),
    BALSA(0xA9A299, (IWoodType)EnumForestryWoodType.BALSA),
    WILLOW(11710818, (IWoodType)EnumForestryWoodType.WILLOW),
    WALNUT(6836802, (IWoodType)EnumForestryWoodType.WALNUT),
    GREENHEART(5144156, (IWoodType)EnumForestryWoodType.GREENHEART),
    CHERRY(11895348, (IWoodType)EnumForestryWoodType.CHERRY),
    MAHOE(8362154, (IWoodType)EnumForestryWoodType.MAHOE),
    POPLAR(13619074, (IWoodType)EnumForestryWoodType.POPLAR),
    PALM(13271115, (IWoodType)EnumForestryWoodType.PALM),
    PAPAYA(14470005, (IWoodType)EnumForestryWoodType.PAPAYA),
    PINE(12885585, (IWoodType)EnumForestryWoodType.PINE),
    PLUM(11364479, (IWoodType)EnumForestryWoodType.PLUM),
    MAPLE(11431211, (IWoodType)EnumForestryWoodType.MAPLE),
    CITRUS(10266653, (IWoodType)EnumForestryWoodType.CITRUS),
    GIGANTEUM(5186590, (IWoodType)EnumForestryWoodType.GIGANTEUM),
    IPE(5057822, (IWoodType)EnumForestryWoodType.IPE),
    PADAUK(11756341, (IWoodType)EnumForestryWoodType.PADAUK),
    COCOBOLO(7541506, (IWoodType)EnumForestryWoodType.COCOBOLO),
    ZEBRAWOOD(10912334, (IWoodType)EnumForestryWoodType.ZEBRAWOOD);

    private final IWoodType woodType;
    private final int color;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite sprite;

    private ForestryPlanks(int color, IWoodType woodType) {
        this.color = color;
        this.woodType = woodType;
    }

    @Override
    public String getPlankTextureName() {
        return "forestry:blocks/wood/planks." + this.name().toLowerCase();
    }

    @Override
    public String getDesignMaterialName() {
        return I18N.localise("extratrees.block.planks.forestry." + this.toString().toLowerCase());
    }

    @Override
    public String getDescription() {
        return I18N.localise("extratrees.block.planks.forestry." + this.toString().toLowerCase() + ".desc");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(TextureMap map) {
        this.sprite = map.func_174942_a(new ResourceLocation(this.getPlankTextureName()));
    }

    @Override
    public int getColour() {
        return this.color;
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public ItemStack getStack(boolean fireproof) {
        return TreeManager.woodAccess.getStack(this.woodType, WoodBlockKind.PLANKS, fireproof);
    }

    @Override
    public ItemStack getStack() {
        return this.getStack(true);
    }

    @Override
    public ItemStack getFence() {
        return TreeManager.woodAccess.getStack(this.woodType, WoodBlockKind.FENCE, false);
    }
}

