/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.liquid;

import binnie.core.liquid.DrinkManager;
import binnie.extratrees.alcohol.GlasswareType;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.ICocktailIngredientProvider;
import binnie.extratrees.alcohol.drink.DrinkLiquid;
import binnie.extratrees.liquid.Alcohol;
import binnie.extratrees.liquid.Juice;
import binnie.extratrees.liquid.Liqueur;
import binnie.extratrees.liquid.MiscFluid;
import binnie.extratrees.liquid.Spirit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public enum Cocktail {
    Bellini("Bellini", GlasswareType.FLUTE, 15974764),
    BlackRussian("Black Russian", GlasswareType.OLD_FASHIONED, 3347992),
    BloodyMary("Bloody Mary", GlasswareType.HIGHBALL, 12660480),
    Cosmopolitan("Cosmopolitan", GlasswareType.COCKTAIL, 0xE20000),
    CubaLibre("Cuba Libre", GlasswareType.HIGHBALL, 9044996),
    FrenchConnection("French Connection", GlasswareType.OLD_FASHIONED, 16166183),
    GodFather("God Father", GlasswareType.OLD_FASHIONED, 13134109),
    GodMother("God Mother", GlasswareType.OLD_FASHIONED, 14644737),
    Grasshopper("Grasshopper", GlasswareType.COCKTAIL, 4441194),
    French75("French 75", GlasswareType.FLUTE, 15521949),
    HarveyWallbanger("Harvey Wallbanger", GlasswareType.HIGHBALL, 16371968),
    HemingwaySpecial("Hemingway Special", GlasswareType.COCKTAIL, 15201205),
    HorsesNeck("Horse's Neck", GlasswareType.OLD_FASHIONED, 16692480),
    IrishCoffee("Irish Coffee", GlasswareType.WINE, 4460034),
    Kir("Kir", GlasswareType.WINE, 16004638),
    Bramble("Bramble", GlasswareType.OLD_FASHIONED, 12804974),
    B52("B-52", GlasswareType.SHOT, 12934656),
    DarkNStormy("Dark 'N' Stormy", GlasswareType.HIGHBALL, 12215848),
    DirtyMartini("Dirty Martini", GlasswareType.COCKTAIL, 14332499),
    ExpressoMartini("Expresso Martini", GlasswareType.COCKTAIL, 6498346),
    FrenchMartini("French Martini", GlasswareType.COCKTAIL, 12660045),
    Kamikaze("Kamikaze", GlasswareType.COCKTAIL, 14801069),
    LemonDropMartini("Lemon Drop Martini", GlasswareType.COCKTAIL, 16375437),
    PiscoSour("Pisco Sour", GlasswareType.OLD_FASHIONED, 15394463),
    RussianSpringPunch("Russian Spring Punch", GlasswareType.HIGHBALL, 11805740),
    SpritzVeneziano("Spritz Veneziano", GlasswareType.OLD_FASHIONED, 15355648),
    TommysMargarita("Tommy's Margartita", GlasswareType.COCKTAIL, 14867592),
    Vesper("Vesper", GlasswareType.COCKTAIL, 0xEEEEEC),
    SexOnTheBeach("Sex on the Beach", GlasswareType.HIGHBALL, 16677426);

    static final Map<String, ICocktailIngredient> cocktailIngredients;
    private final String name;
    private final GlasswareType glasswareType;
    private final int colour;
    private final Map<ICocktailIngredient, Integer> ingredients = new HashMap<ICocktailIngredient, Integer>();

    private Cocktail(String name, GlasswareType glasswareType, int colour) {
        this.name = name;
        this.glasswareType = glasswareType;
        this.colour = colour;
    }

    @Nullable
    public static Cocktail get(Map<ICocktailIngredient, Integer> ingredients) {
        for (Cocktail cocktail : Cocktail.values()) {
            boolean is = true;
            for (Map.Entry<ICocktailIngredient, Integer> entry : ingredients.entrySet()) {
                if (Objects.equals(cocktail.ingredients.get(entry.getKey()), entry.getValue())) continue;
                is = false;
            }
            if (!is) continue;
            return cocktail;
        }
        return null;
    }

    public static void registerIngredient(ICocktailIngredient ingredient) {
        String id = ingredient.getIdentifier().toLowerCase();
        cocktailIngredients.put(id, ingredient);
        DrinkLiquid liquid = new DrinkLiquid(ingredient.getDisplayName(), ingredient.getColor(), ingredient.getTransparency(), ingredient.getABV(), id);
        DrinkManager.registerDrinkLiquid(liquid);
    }

    public static void registerIngredient(ICocktailIngredientProvider ingredient) {
        Cocktail.registerIngredient(ingredient.getIngredient());
    }

    public static void registerIngredients(ICocktailIngredientProvider[] ingredients) {
        for (ICocktailIngredientProvider ingredient : ingredients) {
            Cocktail.registerIngredient(ingredient.getIngredient());
        }
    }

    public static ICocktailIngredient getIngredient(String name2) {
        return cocktailIngredients.get(name2.toLowerCase());
    }

    public static boolean isIngredient(String name) {
        return cocktailIngredients.containsKey(name.toLowerCase());
    }

    private void add(ICocktailIngredient ingredient, int ratio) {
        this.ingredients.put(ingredient, ratio);
    }

    private void add(ICocktailIngredientProvider ingredient, int ratio) {
        this.add(ingredient.getIngredient(), ratio);
    }

    static {
        cocktailIngredients = new HashMap<String, ICocktailIngredient>();
        Bellini.add(Alcohol.SparklingWine, 2);
        Bellini.add(Juice.Peach, 1);
        BlackRussian.add(Spirit.Vodka, 5);
        BlackRussian.add(Liqueur.Coffee, 2);
        BloodyMary.add(Spirit.Vodka, 3);
        BloodyMary.add(Juice.Tomato, 6);
        BloodyMary.add(Juice.Lemon, 1);
        Cosmopolitan.add(Spirit.Vodka, 3);
        Cosmopolitan.add(Liqueur.Orange, 1);
        Cosmopolitan.add(Juice.Lime, 1);
        Cosmopolitan.add(Juice.Cranberry, 2);
        CubaLibre.add(MiscFluid.CarbonatedWater, 12);
        CubaLibre.add(Spirit.WhiteRum, 5);
        CubaLibre.add(Juice.Lime, 1);
        FrenchConnection.add(Spirit.Brandy, 1);
        FrenchConnection.add(Liqueur.Almond, 1);
        GodFather.add(Spirit.Whiskey, 1);
        GodFather.add(Liqueur.Almond, 1);
        GodMother.add(Spirit.Vodka, 1);
        GodFather.add(Liqueur.Almond, 1);
        Grasshopper.add(Liqueur.Mint, 1);
        Grasshopper.add(Liqueur.Chocolate, 1);
        Grasshopper.add(MiscFluid.Cream, 1);
        French75.add(Spirit.Gin, 2);
        French75.add(Juice.Lemon, 1);
        French75.add(Alcohol.SparklingWine, 4);
        HarveyWallbanger.add(Spirit.Vodka, 3);
        HarveyWallbanger.add(Liqueur.Herbal, 1);
        HarveyWallbanger.add(Juice.Orange, 6);
        HemingwaySpecial.add(Spirit.WhiteRum, 4);
        HemingwaySpecial.add(Juice.Grapefruit, 3);
        HemingwaySpecial.add(Liqueur.Cherry, 1);
        HemingwaySpecial.add(Juice.Lime, 1);
        HorsesNeck.add(Spirit.Brandy, 1);
        HorsesNeck.add(MiscFluid.GingerAle, 3);
        IrishCoffee.add(Spirit.Whiskey, 2);
        IrishCoffee.add(MiscFluid.Coffee, 4);
        IrishCoffee.add(MiscFluid.Cream, 2);
        Kir.add(Alcohol.WhiteWine, 9);
        Kir.add(Liqueur.Blackcurrant, 1);
        Bramble.add(Spirit.Gin, 4);
        Bramble.add(Juice.Lemon, 2);
        Bramble.add(MiscFluid.SugarSyrup, 1);
        Bramble.add(Liqueur.Blackberry, 2);
        B52.add(Liqueur.Coffee, 1);
        B52.add(Liqueur.Orange, 1);
        DarkNStormy.add(Spirit.DarkRum, 1);
        DarkNStormy.add(MiscFluid.GingerAle, 3);
        DirtyMartini.add(Spirit.Vodka, 6);
        DirtyMartini.add(Spirit.FortifiedWine, 1);
        DirtyMartini.add(Juice.Olive, 1);
        ExpressoMartini.add(Spirit.Vodka, 5);
        ExpressoMartini.add(Liqueur.Coffee, 1);
        ExpressoMartini.add(MiscFluid.SugarSyrup, 1);
        ExpressoMartini.add(MiscFluid.Coffee, 1);
        FrenchMartini.add(Spirit.Vodka, 3);
        FrenchMartini.add(Liqueur.Raspberry, 1);
        FrenchMartini.add(Juice.Pineapple, 1);
        Kamikaze.add(Spirit.Vodka, 1);
        Kamikaze.add(Liqueur.Orange, 1);
        Kamikaze.add(Juice.Lime, 1);
        LemonDropMartini.add(Spirit.Vodka, 5);
        LemonDropMartini.add(Liqueur.Orange, 4);
        LemonDropMartini.add(Juice.Lemon, 3);
        PiscoSour.add(Spirit.Brandy, 8);
        PiscoSour.add(Juice.Lemon, 4);
        PiscoSour.add(MiscFluid.SugarSyrup, 3);
        RussianSpringPunch.add(Spirit.Vodka, 5);
        RussianSpringPunch.add(Juice.Lemon, 5);
        RussianSpringPunch.add(Liqueur.Blackcurrant, 3);
        RussianSpringPunch.add(MiscFluid.SugarSyrup, 1);
        SpritzVeneziano.add(Alcohol.SparklingWine, 6);
        SpritzVeneziano.add(MiscFluid.CarbonatedWater, 1);
        TommysMargarita.add(Spirit.Tequila, 6);
        TommysMargarita.add(Juice.Lime, 2);
        TommysMargarita.add(MiscFluid.AgaveNectar, 1);
        Vesper.add(Spirit.Gin, 8);
        Vesper.add(Spirit.Vodka, 2);
        Vesper.add(Spirit.FortifiedWine, 1);
        SexOnTheBeach.add(Spirit.Vodka, 2);
        SexOnTheBeach.add(Liqueur.Peach, 1);
        SexOnTheBeach.add(Juice.Orange, 2);
        SexOnTheBeach.add(Juice.Cranberry, 2);
    }
}

