/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics.gui.analyst;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITitledWidget;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.util.I18N;
import binnie.core.util.UniqueItemStackSet;
import binnie.genetics.api.analyst.IAnalystManager;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.ISpeciesRoot;
import forestry.arboriculture.FruitProviderPod;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnalystPageFruit
extends Control
implements ITitledWidget {
    public AnalystPageFruit(IWidget parent, IArea area, ITree ind, IAnalystManager analystManager) {
        super(parent, area);
        ControlItemDisplay d;
        this.setColor(0xCC3300);
        ITreeGenome genome = ind.getGenome();
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        IBreedingSystem treeSystem = Binnie.GENETICS.getSystem((ISpeciesRoot)TreeManager.treeRoot);
        String yieldAlleleName = treeSystem.getAlleleName((IChromosomeType)EnumTreeChromosome.YIELD, ind.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.YIELD));
        new ControlTextCentered((IWidget)this, y += 12, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.fruit.yield") + ": " + yieldAlleleName).setColor(this.getColor());
        y += 20;
        UniqueItemStackSet products = new UniqueItemStackSet();
        UniqueItemStackSet specialties = new UniqueItemStackSet();
        UniqueItemStackSet wiid = new UniqueItemStackSet();
        products.addAll(ind.getProducts().keySet());
        specialties.addAll(ind.getSpecialties().keySet());
        try {
            if (ind.getGenome().getFruitProvider() instanceof FruitProviderPod) {
                FruitProviderPod pod = (FruitProviderPod)ind.getGenome().getFruitProvider();
                Field f = FruitProviderPod.class.getDeclaredField("drops");
                f.setAccessible(true);
                Collections.addAll(products, ((Map)f.get(pod)).keySet().toArray(new ItemStack[0]));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (products.size() > 0) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.fruit.natural")).setColor(this.getColor());
            y += 10;
            int w = products.size() * 18 - 2;
            int i = 0;
            for (ItemStack stack : products) {
                d = new ControlItemDisplay(this, (this.getWidth() - w) / 2 + 18 * i, y);
                d.setTooltip();
                d.setItemStack(stack);
            }
            y += 26;
        }
        if (specialties.size() > 0) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.fruit.specialty")).setColor(this.getColor());
            y += 10;
            int w = products.size() * 18 - 2;
            int i = 0;
            for (ItemStack stack : specialties) {
                d = new ControlItemDisplay(this, (this.getWidth() - w) / 2 + 18 * i, y);
                d.setTooltip();
                d.setItemStack(stack);
            }
            y += 26;
        }
        UniqueItemStackSet allProducts = new UniqueItemStackSet();
        allProducts.addAll(products);
        allProducts.addAll(specialties);
        UniqueItemStackSet refinedProducts = new UniqueItemStackSet();
        refinedProducts.addAll(analystManager.getAllProductsAndFluids(allProducts));
        if (refinedProducts.size() > 0) {
            y = analystManager.drawRefined(this, I18N.localise("genetics.gui.analyst.fruit.refined"), y, refinedProducts);
            y += 8;
        }
        if (products.size() == 0 && specialties.size() == 0) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.fruit.noFruits")).setColor(this.getColor());
            y += 28;
        }
        new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.fruit.possible")).setColor(this.getColor());
        y += 12;
        Collection fruitAlleles = Binnie.GENETICS.getChromosomeMap((ISpeciesRoot)TreeManager.treeRoot).get(EnumTreeChromosome.FRUITS);
        for (IFruitFamily fam : ind.getGenome().getPrimary().getSuitableFruit()) {
            UniqueItemStackSet stacks = new UniqueItemStackSet();
            for (IAllele a : fruitAlleles) {
                if (((IAlleleFruit)a).getProvider().getFamily() != fam) continue;
                stacks.addAll(((IAlleleFruit)a).getProvider().getProducts().keySet());
                stacks.addAll(((IAlleleFruit)a).getProvider().getSpecialty().keySet());
                try {
                    if (a.getUID().contains("fruitCocoa")) {
                        stacks.add(new ItemStack(Items.field_151100_aR, 1, 3));
                        continue;
                    }
                    if (!(((IAlleleFruit)a).getProvider() instanceof FruitProviderPod)) continue;
                    FruitProviderPod pod2 = (FruitProviderPod)((IAlleleFruit)a).getProvider();
                    Field field = FruitProviderPod.class.getDeclaredField("drops");
                    field.setAccessible(true);
                    Collections.addAll(stacks, ((Map)field.get(pod2)).keySet().toArray(new ItemStack[0]));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
            y = analystManager.drawRefined(this, TextFormatting.ITALIC + fam.getName(), y, stacks);
            y += 2;
        }
        this.setSize(new Point(this.getWidth(), y + 8));
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.fruit.title");
    }
}

