/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.core.util.TileUtil;
import binnie.extratrees.worldgen.BlockType;
import binnie.extratrees.worldgen.BlockTypeLeaf;
import binnie.extratrees.worldgen.BlockTypeLog;
import binnie.extratrees.worldgen.BlockTypeVoid;
import binnie.extratrees.worldgen.WorldGenBlockType;
import com.mojang.authlib.GameProfile;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.tiles.TileTreeContainer;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenTree
extends WorldGenerator {
    protected final ITreeGenData treeGen;
    protected World world;
    protected Random rand;
    protected int startX;
    protected int startY;
    protected int startZ;
    protected int girth;
    protected int height;
    protected final int minHeight;
    protected final int maxHeight;
    protected boolean spawnPods = false;
    protected final int minPodHeight;
    protected WorldGenBlockType leaf;
    protected WorldGenBlockType wood;
    protected final WorldGenBlockType vine = new BlockType(Blocks.field_150395_bd.func_176223_P());
    protected final WorldGenBlockType air = new BlockTypeVoid();
    protected float bushiness = 0.0f;

    public WorldGenTree(ITreeGenData tree) {
        this.minHeight = 3;
        this.maxHeight = 80;
        this.minPodHeight = 3;
        this.spawnPods = tree.allowsFruitBlocks();
        this.treeGen = tree;
    }

    protected int randBetween(int a, int b) {
        return a + this.rand.nextInt(b - a);
    }

    protected float randBetween(float a, float b) {
        return a + this.rand.nextFloat() * (b - a);
    }

    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateCylinder(new Vector(0.0f, leafSpawn--, 0.0f), 1.0f, 1, this.leaf, false);
        this.generateCylinder(new Vector(0.0f, leafSpawn--, 0.0f), 1.5f, 1, this.leaf, false);
        this.generateCylinder(new Vector(0.0f, leafSpawn--, 0.0f), 2.9f, 1, this.leaf, false);
        this.generateCylinder(new Vector(0.0f, leafSpawn, 0.0f), 2.9f, 1, this.leaf, false);
    }

    public boolean canGrow() {
        return this.treeGen.canGrow(this.world, new BlockPos(this.startX, this.startY, this.startZ), this.treeGen.getGirth(), this.height) != null;
    }

    public void preGenerate() {
        this.height = this.determineHeight(5, 3);
        this.girth = this.determineGirth(this.treeGen.getGirth());
    }

    protected int determineGirth(int base) {
        return base;
    }

    protected int modifyByHeight(int val, int min, int max) {
        int determined = Math.round((float)val * this.treeGen.getHeightModifier());
        return determined < min ? min : (determined > max ? max : determined);
    }

    protected int determineHeight(int required, int variation) {
        int determined = Math.round((float)(required + this.rand.nextInt(variation)) * this.treeGen.getHeightModifier());
        return determined < this.minHeight ? this.minHeight : (determined > this.maxHeight ? this.maxHeight : determined);
    }

    public WorldGenBlockType getLeaf() {
        return this.leaf != null ? this.leaf : (this.leaf = new BlockTypeLeaf(null));
    }

    public WorldGenBlockType getWood() {
        return new BlockTypeLog(this.treeGen);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        this.leaf = new BlockTypeLeaf(WorldGenTree.getOwner(worldIn, position));
        return this.generate(worldIn, rand, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), false);
    }

    @Nullable
    private static GameProfile getOwner(World world, BlockPos pos) {
        TileTreeContainer tile = TileUtil.getTile((IBlockAccess)world, pos, TileTreeContainer.class);
        if (tile == null) {
            return null;
        }
        return tile.getOwnerHandler().getOwner();
    }

    public final boolean generate(World world, Random random, int x, int y, int z, boolean force) {
        this.world = world;
        this.rand = random;
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.leaf = this.getLeaf();
        this.wood = this.getWood();
        this.preGenerate();
        if (!force && !this.canGrow()) {
            return false;
        }
        for (int x2 = 0; x2 < this.girth; ++x2) {
            for (int y2 = 0; y2 < this.girth; ++y2) {
                this.addBlock(x2, 0, y2, new BlockTypeVoid(), true);
            }
        }
        this.generate();
        return true;
    }

    public final Vector getStartVector() {
        return new Vector(this.startX, this.startY, this.startZ);
    }

    protected void generateTreeTrunk(int height, int width) {
        this.generateTreeTrunk(height, width, 0.0f);
    }

    protected void generateTreeTrunk(int height, int width, float vines) {
        int offset = (width - 1) / 2;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < width; ++y) {
                for (int i = 0; i < height; ++i) {
                    this.addWood(x - offset, i, y - offset, true);
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset - 1, i, y - offset);
                    }
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset + 1, i, y - offset);
                    }
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset, i, y - offset - 1);
                    }
                    if (!(this.rand.nextFloat() < vines)) continue;
                    this.addVine(x - offset, i, y - offset + 1);
                }
            }
        }
        if (!this.spawnPods) {
            return;
        }
        for (int y2 = this.minPodHeight; y2 < height; ++y2) {
            for (int x2 = 0; x2 < this.girth; ++x2) {
                for (int z = 0; z < this.girth; ++z) {
                    if (x2 > 0 && x2 < this.girth && z > 0 && z < this.girth) continue;
                    this.treeGen.trySpawnFruitBlock(this.world, this.world.field_73012_v, new BlockPos(this.startX + x2 + 1, this.startY + y2, this.startZ + z));
                    this.treeGen.trySpawnFruitBlock(this.world, this.world.field_73012_v, new BlockPos(this.startX + x2 - 1, this.startY + y2, this.startZ + z));
                    this.treeGen.trySpawnFruitBlock(this.world, this.world.field_73012_v, new BlockPos(this.startX + x2, this.startY + y2, this.startZ + z + 1));
                    this.treeGen.trySpawnFruitBlock(this.world, this.world.field_73012_v, new BlockPos(this.startX + x2, this.startY + y2, this.startZ + z - 1));
                }
            }
        }
    }

    protected void generateSupportStems(int height, int girth, float chance, float maxHeight) {
        int offset = 1;
        for (int x = -offset; x < girth + offset; ++x) {
            for (int z = -offset; z < girth + offset; ++z) {
                if (x == -offset && z == -offset || x == girth + offset && z == girth + offset || x == -offset && z == girth + offset || x == girth + offset && z == -offset) continue;
                int stemHeight = this.rand.nextInt(Math.round((float)height * maxHeight));
                if (!(this.rand.nextFloat() < chance)) continue;
                for (int i = 0; i < stemHeight; ++i) {
                    this.addWood(x, i, z, true);
                }
            }
        }
    }

    protected final void clearBlock(int x, int y, int z) {
        this.air.setBlock(this.world, this.treeGen, new BlockPos(this.startX + x, this.startY + y, this.startZ + z));
    }

    protected final void addBlock(int x, int y, int z, WorldGenBlockType type, boolean doReplace) {
        if (doReplace || this.world.func_175623_d(new BlockPos(this.startX + x, this.startY + y, this.startZ + z))) {
            type.setBlock(this.world, this.treeGen, new BlockPos(this.startX + x, this.startY + y, this.startZ + z));
        }
    }

    protected final void addWood(int x, int y, int z, boolean doReplace) {
        this.addBlock(x, y, z, this.wood, doReplace);
    }

    protected final void addLeaf(int x, int y, int z, boolean doReplace) {
        this.addBlock(x, y, z, this.leaf, doReplace);
    }

    protected final void addVine(int x, int y, int z) {
        this.addBlock(x, y, z, this.vine, false);
    }

    protected final void generateCuboid(Vector start, Vector area, WorldGenBlockType block, boolean doReplace) {
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    this.addBlock(x, y, z, block, doReplace);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateCylinder(Vector center2, float radius, int height, WorldGenBlockType block, boolean doReplace) {
        float centerOffset = (float)(this.girth - 1) / 2.0f;
        Vector center3 = new Vector(center2.x + centerOffset, center2.y, center2.z + centerOffset);
        Vector start = new Vector(center3.x - radius, center3.y, center3.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y, z);
                    Vector vector2 = new Vector(center3.x, y, center3.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01 && (Vector.distance(new Vector(x, y, z), new Vector(center3.x, y, center3.z)) < (double)(radius - 0.5f) || this.rand.nextFloat() >= this.bushiness)) {
                        this.addBlock(x, y, z, block, doReplace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateCircle(Vector center, float radius, int width, int height, WorldGenBlockType block, boolean doReplace) {
        this.generateCircle(center, radius, width, height, block, 1.0f, doReplace);
    }

    protected final void generateCircle(Vector center2, float radius, int width, int height, WorldGenBlockType block, float chance, boolean doReplace) {
        float centerOffset = this.girth % 2 == 0 ? 0.5f : 0.0f;
        Vector center3 = new Vector(center2.x + centerOffset, center2.y, center2.z + centerOffset);
        Vector start = new Vector(center3.x - radius, center3.y, center3.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    double distance;
                    if (this.rand.nextFloat() <= chance && (double)(radius - (float)width) - 0.01 < (distance = Vector.distance(new Vector(x, y, z), new Vector(center3.x, y, center3.z))) && distance <= (double)radius + 0.01) {
                        this.addBlock(x, y, z, block, doReplace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateSphere(Vector center2, int radius, WorldGenBlockType block, boolean doReplace) {
        float centerOffset = (float)(this.girth - 1) / 2.0f;
        Vector center3 = new Vector(center2.x + centerOffset, center2.y, center2.z + centerOffset);
        Vector start = new Vector(center3.x - (float)radius, center3.y - (float)radius, center3.z - (float)radius);
        Vector area = new Vector(radius * 2 + 1, radius * 2 + 1, radius * 2 + 1);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y, z);
                    Vector vector2 = new Vector(center3.x, center3.y, center3.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01) {
                        this.addBlock(x, y, z, block, doReplace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    static class Vector {
        final float x;
        final float y;
        final float z;

        public Vector(float f, float h, float g) {
            this.x = f;
            this.y = h;
            this.z = g;
        }

        public static double distance(Vector a, Vector b) {
            return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0));
        }
    }
}

