/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.WorldGenTree;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.core.worldgen.WorldGenHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenFir {

    public static class BalsamFir
    extends WorldGenTree {
        public BalsamFir(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = 1.0f;
            float width = (float)this.height / this.randBetween(2.0f, 2.5f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float coneHeight = leafSpawn - 1.0f;
            while (leafSpawn > 1.0f) {
                float radius = 1.0f - (leafSpawn - 1.0f) / coneHeight;
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.4f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 2);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class SilverFir
    extends WorldGenTree {
        public SilverFir(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height / this.randBetween(2.5f, 3.0f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.4f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(7, 3);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class DouglasFir
    extends forestry.arboriculture.worldgen.WorldGenTree {
        public DouglasFir(ITreeGenData tree) {
            super(tree, 7, 3);
        }

        protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
            int leafSpawn = this.height + 1;
            int patchyBottom = (int)((float)this.height / 2.5f);
            int bottom = 3 + rand.nextInt(2);
            WorldGenHelper.generateCylinderFromTreeStartPos((World)world, (ITreeBlockType)leaf, (BlockPos)startPos.func_177982_a(0, leafSpawn--, 0), (int)this.girth, (float)this.girth, (int)1, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.AIR);
            WorldGenHelper.generateCylinderFromTreeStartPos((World)world, (ITreeBlockType)leaf, (BlockPos)startPos.func_177982_a(0, leafSpawn--, 0), (int)this.girth, (float)((float)this.girth + 2.0f), (int)1, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.AIR);
            while (leafSpawn > patchyBottom) {
                if (rand.nextFloat() < 0.45f) {
                    WorldGenHelper.generateCircle((World)world, (Random)rand, (BlockPos)startPos.func_177982_a((this.girth - 1) * (rand.nextBoolean() ? -1 : 1), leafSpawn, (this.girth - 1) * (rand.nextBoolean() ? -1 : 1)), (float)2.0f, (int)2, (int)2, (ITreeBlockType)leaf, (float)0.5f, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.SOFT);
                }
                WorldGenHelper.generateCylinderFromTreeStartPos((World)world, (ITreeBlockType)leaf, (BlockPos)startPos.func_177982_a(0, leafSpawn--, 0), (int)this.girth, (float)((float)this.girth + 2.9f - (float)(rand.nextBoolean() ? 1 : 0)), (int)1, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.AIR);
            }
            while (leafSpawn > bottom) {
                WorldGenHelper.generateCylinderFromTreeStartPos((World)world, (ITreeBlockType)leaf, (BlockPos)startPos.func_177982_a(0, leafSpawn--, 0), (int)this.girth, (float)((float)this.girth + 2.3f - (float)(rand.nextBoolean() ? 1 : 0)), (int)1, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.AIR);
            }
            WorldGenHelper.generateCylinderFromTreeStartPos((World)world, (ITreeBlockType)leaf, (BlockPos)startPos.func_177982_a(0, leafSpawn--, 0), (int)this.girth, (float)((float)this.girth + 1.0f), (int)1, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.AIR);
            WorldGenHelper.generateCylinderFromTreeStartPos((World)world, (ITreeBlockType)leaf, (BlockPos)startPos.func_177982_a(0, leafSpawn, 0), (int)this.girth, (float)((float)this.girth - 0.2f), (int)1, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.AIR);
        }
    }
}

