/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.WorldGenTree;
import binnie.extratrees.gen.WorldGenUtils;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.core.worldgen.WorldGenHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenEucalyptus {

    public static class RainbowGum
    extends WorldGenTree {
        public RainbowGum(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(0.5f, 0.6f) * (float)this.height;
            float width = (float)this.height * this.randBetween(0.15f, 0.2f);
            if (width < 1.5f) {
                width = 1.5f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.7f * width, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), width, 1, this.leaf, false);
                float f4 = leafSpawn;
                leafSpawn = f4 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), width - 0.5f, 1, this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(7, 3);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class RoseGum
    extends WorldGenTree {
        public RoseGum(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            int offset = (this.girth - 1) / 2;
            for (int x = 0; x < this.girth; ++x) {
                for (int y = 0; y < this.girth; ++y) {
                    for (int i = 0; i < 2; ++i) {
                    }
                }
            }
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(0.4f, 0.5f) * (float)this.height;
            float width = (float)this.height * this.randBetween(0.05f, 0.1f);
            if (width < 1.5f) {
                width = 1.5f;
            }
            this.bushiness = 0.5f;
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.7f * width, 1, this.leaf, false);
            this.bushiness = 0.1f;
            while (leafSpawn > bottom) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), this.randBetween(0.9f, 1.1f) * width, 1, this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(9, 3);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class SwampGum
    extends forestry.arboriculture.worldgen.WorldGenTree {
        public SwampGum(ITreeGenData tree) {
            super(tree, 14, 3);
        }

        protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
            int leafSpawn = this.height + 2;
            int weakerBottom = (int)((double)this.height * (0.5 + (double)(rand.nextFloat() * 0.3f)));
            int bottom = (int)((double)this.height * (0.45 + (double)(rand.nextFloat() * 0.2f)));
            WorldGenHelper.generateCylinderFromTreeStartPos((World)world, (ITreeBlockType)leaf, (BlockPos)startPos.func_177982_a(0, leafSpawn--, 0), (int)this.girth, (float)((float)this.girth + 0.75f), (int)1, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.SOFT);
            WorldGenHelper.generateCylinderFromTreeStartPos((World)world, (ITreeBlockType)leaf, (BlockPos)startPos.func_177982_a(0, leafSpawn--, 0), (int)this.girth, (float)((float)this.girth + 1.75f), (int)1, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.SOFT);
            while (leafSpawn > weakerBottom) {
                WorldGenUtils.generateCylinderFromTreeStartPos(world, rand, (ITreeBlockType)leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, (float)this.girth + 1.0f + 1.75f * rand.nextFloat(), 1, 0.3f, WorldGenHelper.EnumReplaceMode.SOFT);
            }
            while (leafSpawn > bottom) {
                WorldGenUtils.generateCylinderFromTreeStartPos(world, rand, (ITreeBlockType)leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, (float)this.girth + 0.75f + 1.25f * rand.nextFloat(), 1, 0.3f, WorldGenHelper.EnumReplaceMode.SOFT);
            }
            for (int i = 0; i < 7; ++i) {
                if ((double)rand.nextFloat() > 0.45) {
                    --leafSpawn;
                    continue;
                }
                WorldGenHelper.generateSphereFromTreeStartPos((World)world, (BlockPos)startPos.func_177982_a(rand.nextInt(this.girth) * (rand.nextBoolean() ? -1 : 1), leafSpawn--, rand.nextInt(this.girth) * (rand.nextBoolean() ? -1 : 1)), (int)this.girth, (int)1, (ITreeBlockType)leaf, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.SOFT);
            }
        }
    }
}

