/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.design.EnumPattern;
import binnie.design.api.DesignAPI;
import binnie.design.api.IDesignMaterial;
import binnie.design.api.IDesignSystem;
import binnie.design.api.IPattern;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.carpentry.GlassType;
import binnie.extratrees.items.ExtraTreeItems;
import binnie.extratrees.wood.planks.ExtraTreePlanks;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum DesignSystem implements IDesignSystem
{
    Wood,
    Glass;

    private final Map<Integer, TextureAtlasSprite> primary = new HashMap<Integer, TextureAtlasSprite>();
    private final Map<Integer, TextureAtlasSprite> secondary = new HashMap<Integer, TextureAtlasSprite>();

    private DesignSystem() {
        DesignAPI.manager.registerDesignSystem(this);
    }

    @Override
    public IDesignMaterial getDefaultMaterial() {
        switch (this) {
            case Glass: {
                return GlassType.get(0);
            }
            case Wood: {
                return ExtraTreePlanks.Fir;
            }
        }
        throw new IllegalStateException("Unknown design system: " + this);
    }

    @Override
    public IDesignMaterial getDefaultMaterial2() {
        switch (this) {
            case Glass: {
                return GlassType.get(1);
            }
            case Wood: {
                return ExtraTreePlanks.Whitebeam;
            }
        }
        throw new IllegalStateException("Unknown design system: " + this);
    }

    @Override
    public IDesignMaterial getMaterial(int id) {
        switch (this) {
            case Glass: {
                return GlassType.get(id);
            }
            case Wood: {
                return CarpentryManager.carpentryInterface.getWoodMaterial(id);
            }
        }
        throw new IllegalStateException("Unknown design system: " + this);
    }

    @Override
    public int getMaterialIndex(IDesignMaterial id) {
        switch (this) {
            case Glass: {
                return GlassType.getIndex(id);
            }
            case Wood: {
                return CarpentryManager.carpentryInterface.getCarpentryWoodIndex(id);
            }
        }
        throw new IllegalStateException("Unknown design system: " + this);
    }

    public String getTexturePath() {
        switch (this) {
            case Glass: {
                return "glass";
            }
            case Wood: {
                return "patterns";
            }
        }
        throw new IllegalStateException("Unknown design system: " + this);
    }

    @Override
    @Nullable
    public IDesignMaterial getMaterial(ItemStack stack) {
        switch (this) {
            case Glass: {
                return GlassType.get(stack);
            }
            case Wood: {
                return CarpentryManager.carpentryInterface.getWoodMaterial(stack);
            }
        }
        throw new IllegalStateException("Unknown design system: " + this);
    }

    @Override
    public ItemStack getAdhesive() {
        switch (this) {
            case Glass: {
                return ExtraTreeItems.GLASS_FITTING.get(1);
            }
            case Wood: {
                return ExtraTreeItems.WOOD_WAX.get(1);
            }
        }
        throw new IllegalStateException("Unknown design system: " + this);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getPrimarySprite(IPattern pattern) {
        if (pattern instanceof EnumPattern) {
            return this.primary.get(((EnumPattern)pattern).ordinal());
        }
        return null;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSecondarySprite(IPattern pattern) {
        if (pattern instanceof EnumPattern) {
            return this.secondary.get(((EnumPattern)pattern).ordinal());
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites() {
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        for (EnumPattern pattern : EnumPattern.values()) {
            ResourceLocation primaryLocation = new ResourceLocation(this.getModId(), "blocks/" + this.getTexturePath() + '/' + pattern.toString().toLowerCase() + ".0");
            ResourceLocation secondaryLocation = new ResourceLocation(this.getModId(), "blocks/" + this.getTexturePath() + '/' + pattern.toString().toLowerCase() + ".1");
            this.primary.put(pattern.ordinal(), textureMap.func_174942_a(primaryLocation));
            this.secondary.put(pattern.ordinal(), textureMap.func_174942_a(secondaryLocation));
        }
    }

    public String getModId() {
        return ExtraTrees.instance.getModId();
    }
}

