/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.blocks.property;

import binnie.extratrees.genetics.ETTreeDefinition;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.properties.PropertyHelper;

public class PropertyETTypeFruit
extends PropertyHelper<LeafVariant> {
    @Nullable
    private static List<LeafVariant> definitions = null;
    private final Collection<LeafVariant> allowedValues;
    private final Map<String, LeafVariant> nameToValue = new HashMap<String, LeafVariant>();

    public static List<LeafVariant> getDefinitions() {
        if (definitions == null) {
            definitions = new ArrayList<LeafVariant>();
            int metadata = 0;
            for (ETTreeDefinition definition : ETTreeDefinition.VALUES) {
                if (!definition.hasFruitLeaves()) continue;
                definitions.add(new LeafVariant(definition, metadata++));
            }
        }
        return definitions;
    }

    public static LeafVariant getVariant(int metadata) {
        return PropertyETTypeFruit.getDefinitions().get(metadata);
    }

    public static int getBlockCount(int variantsPerBlock) {
        return (int)Math.ceil((float)PropertyETTypeFruit.getDefinitions().size() / (float)variantsPerBlock);
    }

    public static PropertyETTypeFruit create(String name, int blockNumber, int variantsPerBlock) {
        LeafPredicate filter = new LeafPredicate(blockNumber, variantsPerBlock);
        Collection allowedValues = Collections2.filter(PropertyETTypeFruit.getDefinitions(), (Predicate)filter);
        return new PropertyETTypeFruit(name, allowedValues);
    }

    protected PropertyETTypeFruit(String name, Collection<LeafVariant> allowedValues) {
        super(name, LeafVariant.class);
        this.allowedValues = allowedValues;
        for (LeafVariant t : allowedValues) {
            String s = t.definition.func_176610_l();
            if (this.nameToValue.containsKey(s)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + s + "'");
            }
            this.nameToValue.put(s, t);
        }
    }

    public Collection<LeafVariant> func_177700_c() {
        return this.allowedValues;
    }

    public Optional<LeafVariant> func_185929_b(String value) {
        return Optional.fromNullable((Object)this.nameToValue.get(value));
    }

    public String getName(LeafVariant value) {
        return value.definition.func_176610_l();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PropertyETTypeFruit && super.equals(o)) {
            PropertyETTypeFruit property = (PropertyETTypeFruit)((Object)o);
            return this.allowedValues.equals(property.allowedValues) && this.nameToValue.equals(property.nameToValue);
        }
        return false;
    }

    public LeafVariant getFirstType() {
        return this.func_177700_c().iterator().next();
    }

    private static class LeafPredicate
    implements Predicate<LeafVariant> {
        private final int minMeta;
        private final int maxMeta;

        public LeafPredicate(int blockNumber, int variantsPerBlock) {
            this.minMeta = blockNumber * variantsPerBlock;
            this.maxMeta = this.minMeta + variantsPerBlock - 1;
        }

        public boolean apply(@Nullable LeafVariant variant) {
            return variant != null && variant.metadata >= this.minMeta && variant.metadata <= this.maxMeta;
        }
    }

    public static class LeafVariant
    implements Comparable<LeafVariant> {
        public final ETTreeDefinition definition;
        public final int metadata;

        public LeafVariant(ETTreeDefinition definition, int metadata) {
            this.definition = definition;
            this.metadata = metadata;
        }

        @Override
        public int compareTo(LeafVariant o) {
            return this.metadata - o.metadata;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeafVariant that = (LeafVariant)o;
            return this.metadata == that.metadata && this.definition == that.definition;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.definition, this.metadata});
        }
    }
}

