/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.circuit;

import binnie.core.ModId;
import binnie.core.util.I18N;
import binnie.extrabees.circuit.StimulatorCircuit;
import binnie.extrabees.utils.BeeModifierLogic;
import binnie.extrabees.utils.EnumBeeBooleanModifier;
import binnie.extrabees.utils.EnumBeeModifier;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.circuits.ICircuitLayout;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum AlvearySimulatorCircuitType implements IBeeModifier
{
    LOW_VOLTAGE(3, 10),
    HIGH_VOLTAGE(5, 20),
    PLANT(10, 10),
    DEATH(6, 10),
    LIFE(11, 10),
    NETHER(7, 15),
    MUTATION(4, 15),
    INHIBITOR(1, 10),
    TERRITORY(2, 10);

    private final int recipe;
    private final int power;
    private final BeeModifierLogic logic = new BeeModifierLogic();
    private static final String CIRCUIT_TYPE_KEY = "alvearycircuittype";

    private AlvearySimulatorCircuitType(int recipe, int power) {
        this.recipe = recipe;
        this.power = power;
    }

    public void createCircuit(ICircuitLayout layout) {
        StimulatorCircuit circuit = new StimulatorCircuit(this, layout);
        for (EnumBeeModifier enumBeeModifier : EnumBeeModifier.values()) {
            String localizedString;
            int value;
            float mod = this.logic.getModifier(enumBeeModifier, 1.0f);
            if (mod == 1.0f) continue;
            if (mod > 1.0f) {
                value = (int)((mod - 1.0f) * 100.0f);
                localizedString = I18N.localise(ModId.EXTRA_BEES, "alvearycircuittype.inc", enumBeeModifier.getName(), value);
            } else {
                value = (int)((1.0f - mod) * 100.0f);
                localizedString = I18N.localise(ModId.EXTRA_BEES, "alvearycircuittype.dec", enumBeeModifier.getName(), value);
            }
            circuit.addTooltip(localizedString);
        }
        for (Enum enum_ : EnumBeeBooleanModifier.values()) {
            if (!this.logic.getModifier((EnumBeeBooleanModifier)enum_)) continue;
            circuit.addTooltip(((EnumBeeBooleanModifier)enum_).getName());
        }
    }

    public float getTerritoryModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.TERRITORY, currentModifier);
    }

    public float getMutationModifier(@Nonnull IBeeGenome genome, @Nonnull IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.MUTATION, currentModifier);
    }

    public float getLifespanModifier(@Nonnull IBeeGenome genome, @Nullable IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.LIFESPAN, currentModifier);
    }

    public float getProductionModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.PRODUCTION, currentModifier);
    }

    public float getFloweringModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.FLOWERING, currentModifier);
    }

    public float getGeneticDecay(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.GENETIC_DECAY, currentModifier);
    }

    public boolean isSealed() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SEALED);
    }

    public boolean isSelfLighted() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SELF_LIGHTED);
    }

    public boolean isSunlightSimulated() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SUNLIGHT_STIMULATED);
    }

    public boolean isHellish() {
        return this.logic.getModifier(EnumBeeBooleanModifier.HELLISH);
    }

    public int getRecipe() {
        return this.recipe;
    }

    public int getPower() {
        return this.power;
    }

    static {
        AlvearySimulatorCircuitType.LOW_VOLTAGE.logic.setModifier(EnumBeeModifier.PRODUCTION, 1.5f, 5.0f);
        AlvearySimulatorCircuitType.HIGH_VOLTAGE.logic.setModifier(EnumBeeModifier.PRODUCTION, 2.5f, 10.0f);
        AlvearySimulatorCircuitType.PLANT.logic.setModifier(EnumBeeModifier.FLOWERING, 1.5f, 5.0f);
        AlvearySimulatorCircuitType.DEATH.logic.setModifier(EnumBeeModifier.LIFESPAN, 0.8f, 0.2f);
        AlvearySimulatorCircuitType.LIFE.logic.setModifier(EnumBeeModifier.LIFESPAN, 1.5f, 5.0f);
        AlvearySimulatorCircuitType.NETHER.logic.setModifier(EnumBeeBooleanModifier.HELLISH);
        AlvearySimulatorCircuitType.MUTATION.logic.setModifier(EnumBeeModifier.MUTATION, 1.5f, 5.0f);
        AlvearySimulatorCircuitType.INHIBITOR.logic.setModifier(EnumBeeModifier.TERRITORY, 0.4f, 0.1f);
        AlvearySimulatorCircuitType.INHIBITOR.logic.setModifier(EnumBeeModifier.PRODUCTION, 0.9f, 0.5f);
        AlvearySimulatorCircuitType.TERRITORY.logic.setModifier(EnumBeeModifier.TERRITORY, 1.5f, 5.0f);
        for (AlvearySimulatorCircuitType type : AlvearySimulatorCircuitType.values()) {
            type.logic.setModifier(EnumBeeModifier.GENETIC_DECAY, 1.5f, 10.0f);
        }
    }
}

