/*
 * Decompiled with CFR 0.152.
 */
package binnie.design;

import binnie.design.api.IDesign;
import binnie.design.api.IDesignCategory;
import binnie.design.api.IDesignManager;
import binnie.design.api.IDesignSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DesignerManager
implements IDesignManager {
    private static final Map<Integer, IDesign> designMap = new LinkedHashMap<Integer, IDesign>();
    private static final Map<String, IDesignCategory> designCategories = new HashMap<String, IDesignCategory>();
    private final List<IDesignSystem> systems = new ArrayList<IDesignSystem>();

    DesignerManager() {
    }

    @Override
    public void registerDesignSystem(IDesignSystem system) {
        this.systems.add(system);
    }

    @Override
    public Collection<IDesignSystem> getDesignSystems() {
        return this.systems;
    }

    @Override
    public boolean registerDesign(int index, IDesign design) {
        return designMap.put(index, design) == null;
    }

    @Override
    public int getDesignIndex(IDesign design) {
        for (Integer integer : designMap.keySet()) {
            if (!designMap.get(integer).equals(design)) continue;
            return integer;
        }
        return -1;
    }

    @Override
    public IDesign getDesign(int index) {
        return designMap.get(index);
    }

    @Override
    public boolean registerDesignCategory(IDesignCategory category) {
        return designCategories.put(category.getId(), category) == null;
    }

    @Override
    public Collection<IDesignCategory> getAllDesignCategories() {
        ArrayList<IDesignCategory> categories = new ArrayList<IDesignCategory>();
        for (IDesignCategory category : designCategories.values()) {
            if (category.getDesigns().size() <= 0) continue;
            categories.add(category);
        }
        return categories;
    }

    @Override
    public List<IDesign> getSortedDesigns() {
        ArrayList<IDesign> designs = new ArrayList<IDesign>();
        for (IDesignCategory category : this.getAllDesignCategories()) {
            designs.addAll(category.getDesigns());
        }
        return designs;
    }
}

