/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.ModId;
import binnie.core.api.gui.Alignment;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.IPoint;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.MinecraftTooltip;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.textures.CraftGUITexture;
import binnie.core.machines.Machine;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import java.text.NumberFormat;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlEnergyBar
extends Control
implements ITooltip {
    public static boolean isError;
    private final Alignment direction;

    public ControlEnergyBar(IWidget parent, int x, int y, int width, int height, Alignment direction) {
        super(parent, x, y, width, height);
        this.direction = direction;
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    public float getPercentage() {
        float percentage = 100.0f * this.getStoredEnergy() / this.getMaxEnergy();
        if (percentage > 100.0f) {
            percentage = 100.0f;
        }
        return percentage;
    }

    private float getStoredEnergy() {
        return ((Window)Window.get(this)).getContainer().getPowerInfo().getStoredEnergy();
    }

    private float getMaxEnergy() {
        return ((Window)Window.get(this)).getContainer().getPowerInfo().getMaxEnergy();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        tooltip.add(I18N.localise(ModId.CORE, "gui.energy.bar", new Object[0]));
        NumberFormat numberFormat = I18N.getNumberFormat();
        String storedEnergy = numberFormat.format(this.getStoredEnergy());
        String maxEnergy = numberFormat.format(this.getMaxEnergy());
        String energyString = TextFormatting.GRAY + storedEnergy + '/' + maxEnergy + " RF";
        tooltip.add(energyString);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getHelpTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        tooltip.add(I18N.localise(ModId.CORE, "gui.energy.bar", new Object[0]));
        if (tooltipFlag.func_194127_a()) {
            String currentFormat = I18N.localise(ModId.CORE, "gui.energy.amount.current", new Object[0]);
            NumberFormat numberFormat = I18N.getNumberFormat();
            String currentString = currentFormat.replace("$MAX$", numberFormat.format(this.getStoredEnergy())).replace("$PERCENT$", I18N.getPercentFormat().format((double)this.getPercentage() / 100.0));
            tooltip.add(TextFormatting.GRAY + currentString);
            String maxEnergy = numberFormat.format(this.getMaxEnergy());
            tooltip.add(TextFormatting.GRAY + I18N.localise(ModId.CORE, "gui.energy.capacity", maxEnergy));
            IProcess process = Machine.getInterface(IProcess.class, ((Window)Window.get(this)).getInventory());
            if (process != null) {
                String energyPerTick = numberFormat.format((int)process.getEnergyPerTick());
                tooltip.add(TextFormatting.GRAY + I18N.localise(ModId.CORE, "gui.energy.cost.per.tick", energyPerTick));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUI.RENDER.texture((Object)CraftGUITexture.ENERGY_BAR_BACK, this.getArea());
        float percentage = this.getPercentage() / 100.0f;
        int colourFromPercentage = this.getColourFromPercentage(percentage);
        RenderUtil.setColour(colourFromPercentage);
        IArea area = this.getArea();
        switch (this.direction) {
            case TOP: 
            case BOTTOM: {
                IPoint fullSize = area.size();
                int height = Math.round((float)fullSize.yPos() * percentage);
                area.setSize(new Point(fullSize.xPos(), height));
                area.setYPos(fullSize.yPos() - height);
                break;
            }
            case LEFT: 
            case RIGHT: {
                int width = Math.round((float)area.size().xPos() * percentage);
                area.setSize(new Point(width, area.size().yPos()));
                break;
            }
        }
        if (this.isMouseOver() && ((Window)Window.get(this)).getGui().isHelpMode()) {
            int c = -1442840576 + MinecraftTooltip.getOutline(Tooltip.Type.HELP);
            RenderUtil.drawGradientRect(this.getArea().inset(1), c, c);
        } else if (isError) {
            int c = -1442840576 + MinecraftTooltip.getOutline(MinecraftTooltip.Type.ERROR);
            RenderUtil.drawGradientRect(this.getArea().inset(1), c, c);
        }
        CraftGUI.RENDER.texture((Object)CraftGUITexture.ENERGY_BAR_GLOW, area);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CraftGUI.RENDER.texture((Object)CraftGUITexture.ENERGY_BAR_GLASS, this.getArea());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderForeground(int guiWidth, int guiHeight) {
        if (this.isMouseOver() && ((Window)Window.get(this)).getGui().isHelpMode()) {
            IArea area = this.getArea();
            RenderUtil.setColour(MinecraftTooltip.getOutline(Tooltip.Type.HELP));
            CraftGUI.RENDER.texture((Object)CraftGUITexture.OUTLINE, area.outset(1));
        } else if (isError) {
            IArea area = this.getArea();
            RenderUtil.setColour(MinecraftTooltip.getOutline(MinecraftTooltip.Type.ERROR));
            CraftGUI.RENDER.texture((Object)CraftGUITexture.OUTLINE, area.outset(1));
        }
    }

    public int getColourFromPercentage(float percentage) {
        if ((double)percentage > 0.5) {
            int r = (int)((1.0 - 2.0 * ((double)percentage - 0.5)) * 255.0);
            return (r << 16) + 65280;
        }
        int g = (int)(255.0f * (2.0f * percentage));
        return 0xFF0000 + (g << 8);
    }
}

